/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.client.WebTarget;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldPartial<F extends BaseField> {
    public static final String FIELDS_KEYWORD = "fields";
    public static final FieldPartial<BaseField> TOTAL_PARTIAL = new FieldPartial(new BaseField[]{BaseField.TOTAL});
    private final Set<F> fields;

    public FieldPartial(F ... fields) {
        this(FieldPartial.convertArrayToSet(fields));
    }

    public FieldPartial(Iterable<F> fields) {
        this(FieldPartial.convertIterableToSet(fields));
    }

    public FieldPartial(Set<F> fields) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Fields can't be empty");
        }
        this.fields = fields;
    }

    public Set<F> getFields() {
        return this.fields;
    }

    public Set<String> getFieldNameSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.fields.size());
        for (BaseField field : this.fields) {
            set.add(field.getName());
        }
        return set;
    }

    public FieldPartial<F> union(FieldPartial<F> that) {
        return new FieldPartial<F>(this.unionFields(that));
    }

    protected Set<F> unionFields(FieldPartial<F> that) {
        LinkedHashMap<String, BaseField> thatFields = new LinkedHashMap<String, BaseField>();
        for (BaseField thatField : that.fields) {
            thatFields.put(thatField.getName(), thatField);
        }
        LinkedHashSet<BaseField> newFields = new LinkedHashSet<BaseField>();
        for (BaseField thisField : this.fields) {
            BaseField thatField = (BaseField)thatFields.remove(thisField.getName());
            if (thatField != null) {
                newFields.add(thisField.union(thatField));
                continue;
            }
            newFields.add(thisField);
        }
        for (BaseField thatField : thatFields.values()) {
            newFields.add(thatField);
        }
        return newFields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (BaseField field : this.fields) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            field.append(builder);
        }
        return builder.toString();
    }

    private static <T> Set<T> convertArrayToSet(T[] arr) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            set.add(arr[i]);
        }
        return set;
    }

    private static <T> Set<T> convertIterableToSet(Iterable<T> iterable) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T field : iterable) {
            set.add(field);
        }
        return set;
    }

    @NotNull
    public static WebTarget apply(@NotNull WebTarget resource, @Nullable FieldPartial partial) {
        if (partial != null) {
            resource = resource.queryParam(FIELDS_KEYWORD, new Object[]{BaseClient.wrapObject(partial)});
        }
        return resource;
    }
}

