/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.CredentialsJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthModuleClient
extends BaseClient {
    public AuthModuleClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public AuthModuleClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("authmodules"), container);
    }

    @NotNull
    public Page getAuthModulePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Authmodule> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public AuthmoduleJSON createAuthModule(@NotNull AuthmoduleJSON entity, @Nullable FieldPartial<Partial.Authmodule> partial) {
        return (AuthmoduleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), AuthmoduleJSON.class);
    }

    @Nullable
    public AuthmoduleJSON getAuthModule(@NotNull String authModuleId, @Nullable FieldPartial<Partial.Authmodule> partial) {
        return this.get(null, authModuleId, partial);
    }

    @Nullable
    public AuthmoduleJSON getAuthModuleByName(@NotNull String name, @Nullable FieldPartial<Partial.Authmodule> partial) {
        return this.get("byname", name, partial);
    }

    @Nullable
    public AuthmoduleJSON getAuthModuleByUrl(@NotNull String url, @Nullable FieldPartial<Partial.Authmodule> partial) {
        return this.get("byurl", url, partial);
    }

    private AuthmoduleJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Authmodule> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (AuthmoduleJSON)this.prepare(resource).get(AuthmoduleJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteAuthModule(@NotNull String authModuleId) {
        WebTarget path = this.path(authModuleId);
        this.prepare(path).delete(String.class);
    }

    public void updateAuthModule(@NotNull String authModuleId, @NotNull AuthmoduleJSON entity) {
        this.prepare(this.path(authModuleId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public DetailsJSON resolve(@NotNull String authModuleId, @NotNull CredentialsJSON entity, @Nullable FieldPartial<Partial.Details> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(authModuleId);
        return (DetailsJSON)this.prepare(r.path("resolve")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<DetailsJSON>(){});
    }

    @NotNull
    public AutoJoinGroupClient getAutojoingroupsClient(@NotNull String authModuleId) {
        return new AutoJoinGroupClient(this.path(authModuleId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class AutoJoinGroupClient
    extends BaseClient {
        private AutoJoinGroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("autojoingroups"), container);
        }

        @NotNull
        public Page getAutoJoinGroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addAutoJoinGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getAutoJoinGroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeAutoJoinGroup(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="autojoingroups")
            private List<UserGroupJSON> autojoingroups;

            @NotNull
            public List<UserGroupJSON> getAutojoingroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.autojoingroups != null ? this.autojoingroups : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<AuthmoduleJSON> {
        @XmlElement(name="authmodules")
        private List<AuthmoduleJSON> authmodules;

        @NotNull
        public List<AuthmoduleJSON> getAuthmodules() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<AuthmoduleJSON> getItems() {
            return this.authmodules != null ? this.authmodules : new ArrayList(0);
        }
    }
}

