/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.MetricsJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricClient
extends BaseClient {
    public MetricClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public MetricClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("metrics"), container);
    }

    @NotNull
    public Page getMetricPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Metrics> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @Nullable
    public MetricsJSON getMetric(@NotNull String metricId, @Nullable FieldPartial<Partial.Metrics> partial) {
        return this.get(null, metricId, partial);
    }

    private MetricsJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Metrics> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (MetricsJSON)this.prepare(resource).get(MetricsJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void dumpDiagnostics() {
        WebTarget resource;
        WebTarget r = resource = this.apply(null);
        this.prepare(r.path("dumpDiagnostics")).method("POST");
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<MetricsJSON> {
        @XmlElement(name="metrics")
        private List<MetricsJSON> metrics;

        @NotNull
        public List<MetricsJSON> getMetrics() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<MetricsJSON> getItems() {
            return this.metrics != null ? this.metrics : new ArrayList(0);
        }
    }
}

