/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.CachedPermissionJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionClient
extends BaseClient {
    public PermissionClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public PermissionClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("permissions"), container);
    }

    @NotNull
    public Page getPermissionPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Permission> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public PermissionJSON createPermission(@NotNull PermissionJSON entity, @Nullable FieldPartial<Partial.Permission> partial) {
        return (PermissionJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), PermissionJSON.class);
    }

    @Nullable
    public PermissionJSON getPermission(@NotNull String permissionId, @Nullable FieldPartial<Partial.Permission> partial) {
        return this.get(null, permissionId, partial);
    }

    @Nullable
    public PermissionJSON getPermissionByName(@NotNull String name, @Nullable FieldPartial<Partial.Permission> partial) {
        return this.get("byname", name, partial);
    }

    private PermissionJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Permission> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (PermissionJSON)this.prepare(resource).get(PermissionJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deletePermission(@NotNull String permissionId) {
        WebTarget path = this.path(permissionId);
        this.prepare(path).delete(String.class);
    }

    public void updatePermission(@NotNull String permissionId, @NotNull PermissionJSON entity) {
        this.prepare(this.path(permissionId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public List<CachedPermissionJSON> cache(@Nullable String query2, @Nullable String principal, @Nullable FieldPartial<Partial.CachedPermission> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (principal != null) {
            r = r.queryParam("principal", new Object[]{BaseClient.wrapObject(principal)});
        }
        return (List)this.prepare(r.path("cache")).method("GET", (GenericType)new GenericType<List<CachedPermissionJSON>>(){});
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<PermissionJSON> {
        @XmlElement(name="permissions")
        private List<PermissionJSON> permissions;

        @NotNull
        public List<PermissionJSON> getPermissions() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<PermissionJSON> getItems() {
            return this.permissions != null ? this.permissions : new ArrayList(0);
        }
    }
}

