/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRoleClient
extends BaseClient {
    public ProjectRoleClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public ProjectRoleClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("projectroles"), container);
    }

    @NotNull
    public Page getProjectRolePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @Nullable
    public ProjectRoleJSON getProjectRole(@NotNull String projectRoleId, @Nullable FieldPartial<Partial.ProjectRole> partial) {
        return this.get(null, projectRoleId, partial);
    }

    private ProjectRoleJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.ProjectRole> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (ProjectRoleJSON)this.prepare(resource).get(ProjectRoleJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<ProjectRoleJSON> {
        @XmlElement(name="projectroles")
        private List<ProjectRoleJSON> projectroles;

        @NotNull
        public List<ProjectRoleJSON> getProjectroles() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<ProjectRoleJSON> getItems() {
            return this.projectroles != null ? this.projectroles : new ArrayList(0);
        }
    }
}

