/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoleClient
extends BaseClient {
    public RoleClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public RoleClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("roles"), container);
    }

    @NotNull
    public Page getRolePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Role> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public RoleJSON createRole(@NotNull RoleJSON entity, @Nullable FieldPartial<Partial.Role> partial) {
        return (RoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), RoleJSON.class);
    }

    @Nullable
    public RoleJSON getRole(@NotNull String roleId, @Nullable FieldPartial<Partial.Role> partial) {
        return this.get(null, roleId, partial);
    }

    @Nullable
    public RoleJSON getRoleByName(@NotNull String name, @Nullable FieldPartial<Partial.Role> partial) {
        return this.get("byname", name, partial);
    }

    private RoleJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Role> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (RoleJSON)this.prepare(resource).get(RoleJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteRole(@NotNull String roleId, @Nullable String successor) {
        WebTarget path = this.path(roleId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateRole(@NotNull String roleId, @NotNull RoleJSON entity) {
        this.prepare(this.path(roleId)).post(Entity.json((Object)entity), String.class);
    }

    public RoleJSON reset(@NotNull String roleId, @NotNull ServiceJSON entity, @Nullable FieldPartial<Partial.Role> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(roleId);
        return (RoleJSON)this.prepare(r.path("reset")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<RoleJSON>(){});
    }

    public RoleJSON servicepermissions(@NotNull String roleId, @Nullable Boolean add, @Nullable Boolean remove, @NotNull ServiceJSON entity, @Nullable FieldPartial<Partial.Role> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(roleId);
        if (add != null) {
            r = r.queryParam("add", new Object[]{BaseClient.wrapObject(add)});
        }
        if (remove != null) {
            r = r.queryParam("remove", new Object[]{BaseClient.wrapObject(remove)});
        }
        return (RoleJSON)this.prepare(r.path("servicepermissions")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<RoleJSON>(){});
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public RoleJSON merge(@Nullable String key, @Nullable String name, @Nullable String description, @NotNull RoleJSON[] entity, @Nullable FieldPartial<Partial.Role> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (key != null) {
            r = r.queryParam("key", new Object[]{BaseClient.wrapObject(key)});
        }
        if (name != null) {
            r = r.queryParam("name", new Object[]{BaseClient.wrapObject(name)});
        }
        if (description != null) {
            r = r.queryParam("description", new Object[]{BaseClient.wrapObject(description)});
        }
        return (RoleJSON)this.prepare(r.path("merge")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<RoleJSON>(){});
    }

    @NotNull
    public PermissionClient getPermissionsClient(@NotNull String roleId) {
        return new PermissionClient(this.path(roleId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class PermissionClient
    extends BaseClient {
        private PermissionClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("permissions"), container);
        }

        @NotNull
        public Page getPermissionPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Permission> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public PermissionJSON addPermission(@NotNull PermissionJSON entity, @Nullable FieldPartial<Partial.Permission> partial) {
            return (PermissionJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), PermissionJSON.class);
        }

        @NotNull
        public PermissionJSON getPermission(@NotNull String id, @Nullable FieldPartial<Partial.Permission> partial) {
            return (PermissionJSON)this.prepare(this.apply(partial).path(id)).get(PermissionJSON.class);
        }

        public void removePermission(@NotNull String id) {
            this.prepare(this.path(id)).delete(PermissionJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<PermissionJSON> {
            @XmlElement(name="permissions")
            private List<PermissionJSON> permissions;

            @NotNull
            public List<PermissionJSON> getPermissions() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<PermissionJSON> getItems() {
                return this.permissions != null ? this.permissions : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<RoleJSON> {
        @XmlElement(name="roles")
        private List<RoleJSON> roles;

        @NotNull
        public List<RoleJSON> getRoles() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<RoleJSON> getItems() {
            return this.roles != null ? this.roles : new ArrayList(0);
        }
    }
}

