/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.BackupStatusJSON;
import jetbrains.jetpass.rest.dto.LocaleJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SmtpMessageJSON;
import jetbrains.jetpass.rest.dto.UpdateStatusJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingClient
extends BaseClient {
    public SettingClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public SettingClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("settings"), container);
    }

    @NotNull
    public Page getSettingPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Settings> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public SettingsJSON createSetting(@NotNull SettingsJSON entity, @Nullable FieldPartial<Partial.Settings> partial) {
        return (SettingsJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), SettingsJSON.class);
    }

    @Nullable
    public SettingsJSON getSetting(@NotNull String settingId, @Nullable FieldPartial<Partial.Settings> partial) {
        return this.get(null, settingId, partial);
    }

    private SettingsJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Settings> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (SettingsJSON)this.prepare(resource).get(SettingsJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteSetting(@NotNull String settingId, @Nullable String successor) {
        WebTarget path = this.path(settingId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateSetting(@NotNull String settingId, @NotNull SettingsJSON entity) {
        this.prepare(this.path(settingId)).post(Entity.json((Object)entity), String.class);
    }

    public SettingsJSON reset(@NotNull String settingId, @Nullable FieldPartial<Partial.Settings> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(settingId);
        return (SettingsJSON)this.prepare(r.path("reset")).method("POST", (GenericType)new GenericType<SettingsJSON>(){});
    }

    public SettingsJSON test(@NotNull String settingId, @Nullable String contact, @Nullable FieldPartial<Partial.Settings> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(settingId);
        if (contact != null) {
            r = r.queryParam("contact", new Object[]{BaseClient.wrapObject(contact)});
        }
        return (SettingsJSON)this.prepare(r.path("test")).method("POST", (GenericType)new GenericType<SettingsJSON>(){});
    }

    public void sendSMTPMessage(@NotNull SmtpMessageJSON message, boolean requiredEmailVerification) {
        this.prepare(this.resource.path("smtp").path("message").queryParam("requireEmailVerification", new Object[]{requiredEmailVerification})).post(Entity.json((Object)message), String.class);
    }

    public List<LocaleJSON> locales(@Nullable FieldPartial<Partial.Locale> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (List)this.prepare(r.path("locales")).method("GET", (GenericType)new GenericType<List<LocaleJSON>>(){});
    }

    public BackupStatusJSON backupData(@Nullable String targetVersion, @Nullable FieldPartial<Partial.BackupStatus> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (targetVersion != null) {
            r = r.queryParam("targetVersion", new Object[]{BaseClient.wrapObject(targetVersion)});
        }
        return (BackupStatusJSON)this.prepare(r.path("backupData")).method("POST", (GenericType)new GenericType<BackupStatusJSON>(){});
    }

    public UpdateStatusJSON updateStatus(@Nullable FieldPartial<Partial.UpdateStatus> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (UpdateStatusJSON)this.prepare(r.path("updateStatus")).method("GET", (GenericType)new GenericType<UpdateStatusJSON>(){});
    }

    @NotNull
    public UserClient getUsersClient(@NotNull String settingId) {
        return new UserClient(this.path(settingId), this.container);
    }

    @NotNull
    public AutoJoinGroupClient getAutojoingroupsClient(@NotNull String settingId) {
        return new AutoJoinGroupClient(this.path(settingId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class AutoJoinGroupClient
    extends BaseClient {
        private AutoJoinGroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("autojoingroups"), container);
        }

        @NotNull
        public Page getAutoJoinGroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addAutoJoinGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getAutoJoinGroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeAutoJoinGroup(@NotNull String id) {
            this.prepare(this.path(id).queryParam("keepUsers", new Object[]{false})).delete(UserGroupJSON.class);
        }

        public void removeAutoJoinGroup(@NotNull String id, boolean keepUsers) {
            this.prepare(this.path(id).queryParam("keepUsers", new Object[]{keepUsers})).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="autojoingroups")
            private List<UserGroupJSON> autojoingroups;

            @NotNull
            public List<UserGroupJSON> getAutojoingroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.autojoingroups != null ? this.autojoingroups : new ArrayList(0);
            }
        }
    }

    public static class UserClient
    extends BaseClient {
        private UserClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("users"), container);
        }

        @NotNull
        public Page getUserPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.User> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserJSON addUser(@NotNull UserJSON entity, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserJSON.class);
        }

        @NotNull
        public UserJSON getUser(@NotNull String id, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial).path(id)).get(UserJSON.class);
        }

        public void removeUser(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserJSON> {
            @XmlElement(name="users")
            private List<UserJSON> users;

            @NotNull
            public List<UserJSON> getUsers() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserJSON> getItems() {
                return this.users != null ? this.users : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<SettingsJSON> {
        @XmlElement(name="settings")
        private List<SettingsJSON> settings;

        @NotNull
        public List<SettingsJSON> getSettings() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<SettingsJSON> getItems() {
            return this.settings != null ? this.settings : new ArrayList(0);
        }
    }
}

