/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.oauth2.auth;

import com.intellij.hub.auth.request.AuthRequestParameter;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import jetbrains.jetpass.client.oauth2.OAuth2Flow;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001dB/\b\u0004\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001cH\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\t\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow;", "Ljetbrains/jetpass/client/oauth2/OAuth2Flow;", "builder", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;", "responseType", "", "(Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;Ljava/lang/String;)V", "approvalPrompt", "getApprovalPrompt", "()Ljava/lang/String;", "authURI", "Ljava/net/URI;", "getAuthURI", "()Ljava/net/URI;", "authUri", "getAuthUri", "credentials", "Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "getCredentials", "()Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "message", "getMessage", "redirectUri", "getRedirectUri", "getResponseType", "state", "getState", "buildParams", "Ljavax/ws/rs/core/MultivaluedHashMap;", "Builder", "jetbrains.jetpass.client.oauth2"})
public abstract class OAuth2AuthFlow
extends OAuth2Flow {
    @NotNull
    private final URI authURI;
    @NotNull
    private final AuthRequestParameter.RequestCredentials credentials;
    @Nullable
    private final String approvalPrompt;
    @Nullable
    private final String state;
    @Nullable
    private final String message;
    @Nullable
    private final URI redirectUri;
    @NotNull
    private final String responseType;

    @NotNull
    protected final URI getAuthURI() {
        return this.authURI;
    }

    @NotNull
    protected final AuthRequestParameter.RequestCredentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    protected final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    @Nullable
    protected final String getState() {
        return this.state;
    }

    @Nullable
    protected final String getMessage() {
        return this.message;
    }

    @Nullable
    protected final URI getRedirectUri() {
        return this.redirectUri;
    }

    @NotNull
    public final URI getAuthUri() {
        return OAuth2Flow.Companion.queryParams$jetbrains_jetpass_client_oauth2(this.authURI, (MultivaluedMap<String, String>)((MultivaluedMap)this.buildParams()));
    }

    @NotNull
    protected MultivaluedHashMap<String, String> buildParams() {
        String string;
        MultivaluedHashMap multivaluedHashMap;
        MultivaluedHashMap $receiver = multivaluedHashMap = new MultivaluedHashMap();
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "response_type", this.responseType);
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "client_id", this.getClientServiceId());
        OAuth2Flow.Companion.scope$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "scope", this.getScope(), this.getEncodedScope());
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "message", this.message);
        URI uRI = this.redirectUri;
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "redirect_uri", uRI != null ? uRI.toASCIIString() : null);
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "state", this.state);
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "approval_prompt", this.approvalPrompt);
        OAuth2Flow.Companion companion = OAuth2Flow.Companion;
        MultivaluedMap multivaluedMap = (MultivaluedMap)$receiver;
        String string2 = "request_credentials";
        if (Intrinsics.areEqual((Object)((Object)this.credentials), (Object)((Object)AuthRequestParameter.RequestCredentials.DEFAULT))) {
            string = null;
        } else {
            String string3 = this.credentials.name();
            String string4 = string2;
            MultivaluedMap multivaluedMap2 = multivaluedMap;
            OAuth2Flow.Companion companion2 = companion;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            String string7 = string6;
            companion = companion2;
            multivaluedMap = multivaluedMap2;
            string2 = string4;
            string = string7;
        }
        companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)multivaluedMap, string2, string);
        return multivaluedHashMap;
    }

    @NotNull
    protected final String getResponseType() {
        return this.responseType;
    }

    protected OAuth2AuthFlow(@NotNull Builder<? extends Builder<?, ?>, ? extends OAuth2AuthFlow> builder, @NotNull String responseType) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)responseType, (String)"responseType");
        super((OAuth2Flow.Builder)builder);
        this.responseType = responseType;
        this.authURI = builder.getAuthURI$jetbrains_jetpass_client_oauth2();
        this.credentials = builder.getCredentialsRequest$jetbrains_jetpass_client_oauth2();
        this.approvalPrompt = builder.getApprovalPromptValue$jetbrains_jetpass_client_oauth2();
        this.state = builder.getState$jetbrains_jetpass_client_oauth2();
        this.message = builder.getMessage$jetbrains_jetpass_client_oauth2();
        this.redirectUri = builder.getRedirectUri$jetbrains_jetpass_client_oauth2();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\"\u001a\u00028\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010%J\u0015\u0010\u0018\u001a\u00028\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010#J\u0015\u0010\u001b\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010&J\u0015\u0010\u001b\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010#J\u0015\u0010\u001f\u001a\u00028\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010#R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u000f\u00a8\u0006'"}, d2={"Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;", "B", "Flow", "Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow;", "Ljetbrains/jetpass/client/oauth2/OAuth2Flow$Builder;", "client", "Ljavax/ws/rs/client/Client;", "authURI", "Ljava/net/URI;", "(Ljavax/ws/rs/client/Client;Ljava/net/URI;)V", "approvalPromptValue", "", "getApprovalPromptValue$jetbrains_jetpass_client_oauth2", "()Ljava/lang/String;", "setApprovalPromptValue$jetbrains_jetpass_client_oauth2", "(Ljava/lang/String;)V", "getAuthURI$jetbrains_jetpass_client_oauth2", "()Ljava/net/URI;", "credentialsRequest", "Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "getCredentialsRequest$jetbrains_jetpass_client_oauth2", "()Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "setCredentialsRequest$jetbrains_jetpass_client_oauth2", "(Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;)V", "message", "getMessage$jetbrains_jetpass_client_oauth2", "setMessage$jetbrains_jetpass_client_oauth2", "redirectUri", "getRedirectUri$jetbrains_jetpass_client_oauth2", "setRedirectUri$jetbrains_jetpass_client_oauth2", "(Ljava/net/URI;)V", "state", "getState$jetbrains_jetpass_client_oauth2", "setState$jetbrains_jetpass_client_oauth2", "approval", "(Ljava/lang/String;)Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;", "credentials", "(Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;)Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;", "(Ljava/net/URI;)Ljetbrains/jetpass/client/oauth2/auth/OAuth2AuthFlow$Builder;", "jetbrains.jetpass.client.oauth2"})
    public static abstract class Builder<B extends Builder<B, Flow>, Flow extends OAuth2AuthFlow>
    extends OAuth2Flow.Builder<B, Flow> {
        @NotNull
        private AuthRequestParameter.RequestCredentials credentialsRequest;
        @Nullable
        private String approvalPromptValue;
        @Nullable
        private String state;
        @Nullable
        private String message;
        @Nullable
        private URI redirectUri;
        @NotNull
        private final URI authURI;

        @NotNull
        public final AuthRequestParameter.RequestCredentials getCredentialsRequest$jetbrains_jetpass_client_oauth2() {
            return this.credentialsRequest;
        }

        public final void setCredentialsRequest$jetbrains_jetpass_client_oauth2(@NotNull AuthRequestParameter.RequestCredentials requestCredentials) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)requestCredentials), (String)"<set-?>");
            this.credentialsRequest = requestCredentials;
        }

        @Nullable
        public final String getApprovalPromptValue$jetbrains_jetpass_client_oauth2() {
            return this.approvalPromptValue;
        }

        public final void setApprovalPromptValue$jetbrains_jetpass_client_oauth2(@Nullable String string) {
            this.approvalPromptValue = string;
        }

        @Nullable
        public final String getState$jetbrains_jetpass_client_oauth2() {
            return this.state;
        }

        public final void setState$jetbrains_jetpass_client_oauth2(@Nullable String string) {
            this.state = string;
        }

        @Nullable
        public final String getMessage$jetbrains_jetpass_client_oauth2() {
            return this.message;
        }

        public final void setMessage$jetbrains_jetpass_client_oauth2(@Nullable String string) {
            this.message = string;
        }

        @Nullable
        public final URI getRedirectUri$jetbrains_jetpass_client_oauth2() {
            return this.redirectUri;
        }

        public final void setRedirectUri$jetbrains_jetpass_client_oauth2(@Nullable URI uRI) {
            this.redirectUri = uRI;
        }

        @NotNull
        public final B credentials(@NotNull AuthRequestParameter.RequestCredentials credentialsRequest) {
            Builder this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)credentialsRequest), (String)"credentialsRequest");
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.credentialsRequest = credentialsRequest;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final B state(@Nullable String state) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.state = state;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final B message(@Nullable String message) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.message = message;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final B approval(@Nullable String approvalPromptValue) {
            String string;
            String string2;
            String string3;
            Builder builder;
            String string4;
            Builder this_$iv;
            Builder builder2 = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder2;
            Builder builder3 = this;
            String string5 = approvalPromptValue;
            if (string5 != null) {
                string4 = string5;
                builder = builder3;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                string3 = string7;
                builder3 = builder;
                string2 = string3;
            } else {
                string2 = null;
            }
            String string8 = string2;
            string4 = "auto";
            string3 = string8;
            builder = builder3;
            String string9 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
            String string10 = string9;
            Builder builder4 = builder;
            if (Intrinsics.areEqual((Object)string3, (Object)string10)) {
                string = "auto";
            } else {
                string4 = "force";
                string3 = string8;
                builder = builder4;
                String string11 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).toLowerCase()");
                string10 = string11;
                builder4 = builder;
                string = Intrinsics.areEqual((Object)string3, (Object)string10) ? "force" : null;
            }
            builder4.approvalPromptValue = string;
            Builder builder5 = builder2;
            if (builder5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder5));
        }

        @NotNull
        public final B redirectUri(@Nullable URI redirectUri) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.redirectUri = redirectUri;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder2));
        }

        @NotNull
        public final B redirectUri(@Nullable String redirectUri) {
            URI uRI;
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            Builder builder2 = this;
            String string = redirectUri;
            if (string != null) {
                String string2 = string;
                Builder builder3 = builder2;
                String it = string2;
                URI uRI2 = URI.create(redirectUri);
                builder2 = builder3;
                uRI = uRI2;
            } else {
                uRI = null;
            }
            builder2.redirectUri = uRI;
            Builder builder4 = builder;
            if (builder4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (B)((Builder)((OAuth2Flow.Builder)builder4));
        }

        @NotNull
        public final URI getAuthURI$jetbrains_jetpass_client_oauth2() {
            return this.authURI;
        }

        protected Builder(@NotNull Client client, @NotNull URI authURI) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)authURI, (String)"authURI");
            super(client);
            this.authURI = authURI;
            this.credentialsRequest = AuthRequestParameter.RequestCredentials.DEFAULT;
        }
    }
}

