/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.api.security.RoleDAO;
import jetbrains.jetpass.dao.remote.api.RemoteDAO;
import jetbrains.jetpass.dao.remote.api.RemoteNamedMutableDAO;
import jetbrains.jetpass.dao.remote.api.RemoteServiceDAO;
import jetbrains.jetpass.dao.remote.api.util.IdRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.ItemRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.RemoteRelationEnd;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.Page;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fH\u0017J\u0018\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0017J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J\u001a\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0014J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J \u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J4\u0010%\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\b\u0010(\u001a\u0004\u0018\u00010\u00112\b\u0010)\u001a\u0004\u0018\u00010\u00112\b\u0010*\u001a\u0004\u0018\u00010\u0011H\u0017J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0011H\u0016J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fH\u0017J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011H\u0017J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0017J\u0010\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020\u0011H\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00064"}, d2={"Ljetbrains/jetpass/dao/remote/api/security/RemoteRoleDAO;", "Ljetbrains/jetpass/dao/api/security/RoleDAO;", "Ljetbrains/jetpass/dao/remote/api/RemoteNamedMutableDAO;", "Ljetbrains/jetpass/api/security/Role;", "Ljetbrains/jetpass/rest/dto/RoleJSON;", "Ljetbrains/jetpass/client/accounts/Partial$Role;", "client", "Ljetbrains/jetpass/client/accounts/RoleClient;", "(Ljetbrains/jetpass/client/accounts/RoleClient;)V", "getClient", "()Ljetbrains/jetpass/client/accounts/RoleClient;", "addPermission", "Ljetbrains/jetpass/api/security/Permission;", "role", "permission", "", "roleId", "", "permissionId", "addServicePermissions", "serviceID", "createPartial", "Ljetbrains/jetpass/client/FieldPartial;", "fieldName", "doCreate", "json", "partial", "doDelete", "id", "successor", "doUpdate", "change", "fetchItem", "fetchPage", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "merge", "roles", "", "key", "name", "description", "newJSON", "removePermission", "removeServicePermissions", "serviceId", "resetPermissions", "toJSON", "item", "toServiceJSON", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "jetbrains.jetpass.dao.remote"})
public final class RemoteRoleDAO
extends RemoteNamedMutableDAO<Role, RoleJSON, Partial.Role>
implements RoleDAO {
    @NotNull
    private final RoleClient client;

    @Override
    @NotNull
    protected Page<RoleJSON> fetchPage(@NotNull BaseFilter<?> filter2, @NotNull FieldPartial<Partial.Role> partial) {
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        RoleClient.Page page = this.client.getRolePage(filter2, partial);
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"client.getRolePage(filter, partial)");
        return page;
    }

    @Override
    @Nullable
    protected RoleJSON fetchItem(@NotNull String id, @NotNull FieldPartial<Partial.Role> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getRole(id, partial);
    }

    @Override
    @NotNull
    public FieldPartial<Partial.Role> createPartial(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Partial<Partial.Role> partial = Partial.role(new Partial.Role(fieldName));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.role(Partial.Role(fieldName))");
        return partial;
    }

    @Override
    @NotNull
    protected RoleJSON doCreate(@NotNull RoleJSON json, @NotNull FieldPartial<Partial.Role> partial) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        RoleJSON roleJSON = this.client.createRole(json, partial);
        Intrinsics.checkExpressionValueIsNotNull((Object)roleJSON, (String)"client.createRole(json, partial)");
        return roleJSON;
    }

    @Override
    protected void doUpdate(@NotNull String id, @NotNull RoleJSON change) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        this.client.updateRole(id, change);
    }

    @Override
    protected void doDelete(@NotNull String id, @Nullable String successor) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.client.deleteRole(id, successor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated(message="Use addPermission(role, permission) instead")
    public void addPermission(@NotNull String roleId, @NotNull String permissionId) throws DataAccessException {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getPermissionDAO();
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, roleId);
        RemoteRelationEnd remoteRelationEnd = new IdRemoteRelationEnd(childDAO$iv, permissionId);
        boolean checkChildExistence$iv$iv = true;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void idPartial;
            void permissionJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            PermissionJSON permissionJSON2 = (PermissionJSON)childJSON$iv$iv;
            String roleId2 = parentId$iv$iv;
            PermissionJSON permissionJSON3 = this.client.getPermissionsClient(roleId2).addPermission((PermissionJSON)permissionJSON, (FieldPartial<Partial.Permission>)idPartial);
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionJSON3, (String)"client.getPermissionsCli\u2026ermissionJSON, idPartial)");
            idItem = permissionJSON3;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        childEnd$iv$iv.resolve(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated(message="User removePermission(role, permission) instead")
    public void removePermission(@NotNull String roleId, @NotNull String permissionId) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        Intrinsics.checkParameterIsNotNull((Object)permissionId, (String)"permissionId");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getPermissionDAO();
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, roleId);
        RemoteRelationEnd childEnd$iv$iv = new IdRemoteRelationEnd(childDAO$iv, permissionId);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void permissionId2;
            String string = childId$iv$iv;
            String roleId2 = parentId$iv$iv;
            this.client.getPermissionsClient(roleId2).removePermission((String)permissionId2);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Permission addPermission(@NotNull Role role, @NotNull Permission permission) throws DataAccessException {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getPermissionDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, role);
        RemoteRelationEnd remoteRelationEnd = new ItemRemoteRelationEnd(childDAO$iv, permission);
        boolean checkChildExistence$iv$iv = true;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void idPartial;
            void permissionJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            PermissionJSON permissionJSON2 = (PermissionJSON)childJSON$iv$iv;
            String roleId = parentId$iv$iv;
            PermissionJSON permissionJSON3 = this.client.getPermissionsClient(roleId).addPermission((PermissionJSON)permissionJSON, (FieldPartial<Partial.Permission>)idPartial);
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionJSON3, (String)"client.getPermissionsCli\u2026ermissionJSON, idPartial)");
            idItem = permissionJSON3;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        return (Permission)childEnd$iv$iv.resolve(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removePermission(@NotNull Role role, @NotNull Permission permission) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getPermissionDAO();
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, role);
        RemoteRelationEnd childEnd$iv$iv = new ItemRemoteRelationEnd(childDAO$iv, permission);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void permissionId;
            String string = childId$iv$iv;
            String roleId = parentId$iv$iv;
            this.client.getPermissionsClient(roleId).removePermission((String)permissionId);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    @Override
    public void resetPermissions(@NotNull String roleId, @NotNull String serviceID) throws DataAccessException {
        RoleJSON roleJSON;
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        Intrinsics.checkParameterIsNotNull((Object)serviceID, (String)"serviceID");
        this.getNotNull(roleId);
        ServiceJSON service2 = this.toServiceJSON(serviceID);
        RemoteRoleDAO $receiver$iv = this;
        String id$iv = null;
        try {
            roleJSON = this.client.reset(roleId, service2, (FieldPartial<Partial.Role>)Partial.role(Partial.Role.ID));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        RoleJSON result$iv = roleJSON;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    @Override
    public void addServicePermissions(@NotNull String roleId, @NotNull String serviceID) throws DataAccessException {
        RoleJSON roleJSON;
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        Intrinsics.checkParameterIsNotNull((Object)serviceID, (String)"serviceID");
        this.getNotNull(roleId);
        ServiceJSON service2 = this.toServiceJSON(serviceID);
        RemoteRoleDAO $receiver$iv = this;
        String id$iv = null;
        try {
            roleJSON = this.client.servicepermissions(roleId, true, null, service2, (FieldPartial<Partial.Role>)Partial.role(Partial.Role.ID));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        RoleJSON result$iv = roleJSON;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    @Override
    public void removeServicePermissions(@NotNull String roleId, @NotNull String serviceId) throws DataAccessException {
        RoleJSON roleJSON;
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
        this.getNotNull(roleId);
        ServiceJSON service2 = this.toServiceJSON(serviceId);
        RemoteRoleDAO $receiver$iv = this;
        String id$iv = null;
        try {
            roleJSON = this.client.servicepermissions(roleId, null, true, service2, (FieldPartial<Partial.Role>)Partial.role(Partial.Role.ID));
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, id$iv);
        }
        RoleJSON result$iv = roleJSON;
        $receiver$iv.getRemoteAPI().syncNow();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Role merge(@NotNull Iterable<? extends Role> roles, @Nullable String key, @Nullable String name, @Nullable String description) throws DataAccessException {
        IdItem idItem;
        void $receiver$iv$iv$iv;
        Collection $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(roles, (String)"roles");
        RemoteRoleDAO $receiver$iv = this;
        Collection collection = $receiver$iv$iv = roles;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv;
            IdItem idItem2 = (IdItem)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object j = $receiver$iv.toJSON(it$iv);
            collection2.add(j);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        Collection thisCollection$iv$iv = $receiver$iv$iv;
        RoleJSON[] roleJSONArray = thisCollection$iv$iv.toArray(new RoleJSON[0]);
        if (roleJSONArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdItem[] array$iv = roleJSONArray;
        FieldPartial idPartial$iv = ((RemoteDAO)$receiver$iv).createPartial("id");
        RemoteRoleDAO $receiver$iv$iv2 = $receiver$iv;
        String id$iv$iv = null;
        try {
            void idPartial;
            FieldPartial fieldPartial = idPartial$iv;
            RoleJSON[] rolesArray = (RoleJSON[])array$iv;
            RoleJSON roleJSON = this.client.merge(key, name, description, rolesArray, (FieldPartial<Partial.Role>)idPartial);
            Intrinsics.checkExpressionValueIsNotNull((Object)roleJSON, (String)"client.merge(key, name, \u2026n, rolesArray, idPartial)");
            idItem = roleJSON;
        }
        catch (WebApplicationException ex$iv$iv) {
            throw (Throwable)$receiver$iv$iv2.wrapClientException(ex$iv$iv, id$iv$iv);
        }
        IdItem result$iv$iv = idItem;
        $receiver$iv$iv2.getRemoteAPI().syncNow();
        IdItem mergedJSON$iv = result$iv$iv;
        return (Role)$receiver$iv.getNotNull(mergedJSON$iv.getId());
    }

    @Override
    @NotNull
    public RoleJSON toJSON(@NotNull Role item2) {
        Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item");
        return RoleJSON.wrap(item2);
    }

    @Override
    @NotNull
    public RoleJSON newJSON(@NotNull String id) {
        RoleJSON roleJSON;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        RoleJSON $receiver = roleJSON = new RoleJSON();
        $receiver.setId(id);
        return roleJSON;
    }

    private final ServiceJSON toServiceJSON(String serviceId) throws ItemNotFoundException {
        RemoteServiceDAO remoteServiceDAO;
        RemoteServiceDAO $receiver = remoteServiceDAO = this.getRemoteAPI().getServiceDAO();
        Object i = $receiver.getNotNull(serviceId);
        Intrinsics.checkExpressionValueIsNotNull(i, (String)"getNotNull(serviceId)");
        ServiceJSON serviceJSON = $receiver.toJSON((Service)i);
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceJSON, (String)"toJSON(getNotNull(serviceId))");
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceJSON, (String)"with(remoteAPI.serviceDA\u2026ull(serviceId))\n        }");
        return serviceJSON;
    }

    @NotNull
    public final RoleClient getClient() {
        return this.client;
    }

    public RemoteRoleDAO(@NotNull RoleClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Partial<Partial.Role> partial = Partial.role(Partial.Role.ID, Partial.Role.ALIASES(Partial.Alias.ID), Partial.Role.PERMISSIONS(Partial.Permission.ID));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.role(\n          \u2026  Partial.Permission.ID))");
        super((FieldPartial)partial);
        this.client = client;
    }
}

