/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.pojo.api.authority.profile;

import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmailUtils {
    private static final String EMAIL_REGEXP = "([a-z0-9!#$%&'*+\\\\/=?^_`{|}~.-]+)@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*";
    public static final Regex EMAIL_PATTERN = new Regex("([a-z0-9!#$%&'*+\\\\/=?^_`{|}~.-]+)@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*", RegexOption.IGNORE_CASE);

    @Nullable
    public static String getUsernameFromEmail(@Nullable String email) {
        if (email == null || email.length() == 0) {
            return null;
        }
        int indexOfAt = email.indexOf("@");
        return indexOfAt > 0 ? email.substring(0, indexOfAt) : null;
    }

    @NotNull
    public static String getUsernameOrEmail(@NotNull String email) {
        String login2 = EmailUtils.getUsernameFromEmail(email);
        return login2 != null ? login2 : email;
    }
}

