/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.settings.BackupSettings;
import jetbrains.jetpass.rest.dto.BackupDataJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="backupStatus")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BackupStatusJSON
implements BackupSettings.Status {
    @XmlElement(name="inProgress")
    private Boolean inProgress;
    @XmlElement(name="savedData")
    private List<BackupDataJSON> savedData;

    public BackupStatusJSON() {
    }

    public BackupStatusJSON(@NotNull BackupSettings.Status that) {
        this.setInProgress(that.isInProgress());
        if (that.getSavedData() != null) {
            ArrayList<BackupDataJSON> aggregated = new ArrayList<BackupDataJSON>();
            for (BackupSettings.Data data : that.getSavedData()) {
                aggregated.add(new BackupDataJSON(data));
            }
            this.setSavedData(aggregated);
        }
    }

    @Override
    @Nullable
    public Boolean isInProgress() {
        return this.inProgress;
    }

    @Nullable
    public Iterable<BackupDataJSON> getSavedData() {
        return this.savedData;
    }

    @XmlTransient
    public void setInProgress(@Nullable Boolean inProgress) {
        this.inProgress = inProgress;
    }

    @XmlTransient
    public void setSavedData(@Nullable Iterable<BackupDataJSON> savedData) {
        this.savedData = new ArrayList<BackupDataJSON>();
        if (savedData != null) {
            for (BackupDataJSON it : savedData) {
                this.savedData.add(it);
            }
        }
    }

    @NotNull
    public static BackupStatusJSON wrap(@NotNull BackupSettings.Status that) {
        if (that instanceof BackupStatusJSON) {
            return (BackupStatusJSON)that;
        }
        return new BackupStatusJSON(that);
    }
}

