/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.metrics.Metrics;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DatabaseJSON;
import jetbrains.jetpass.rest.dto.MemoryJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="metrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetricsJSON
implements Metrics {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="availableProcessors")
    private Integer availableProcessors;
    @XmlElement(name="memory")
    private MemoryJSON memory;
    @XmlElement(name="database")
    private DatabaseJSON database;
    @XmlElement(name="serverStartTime")
    private Long serverStartTime;

    public MetricsJSON() {
    }

    public MetricsJSON(@NotNull Metrics that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setAvailableProcessors(that.getAvailableProcessors());
        if (that.getMemory() != null) {
            this.setMemory(new MemoryJSON(that.getMemory()));
        }
        if (that.getDatabase() != null) {
            this.setDatabase(new DatabaseJSON(that.getDatabase()));
        }
        this.setServerStartTime(that.getServerStartTime());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public Integer getAvailableProcessors() {
        return this.availableProcessors;
    }

    @Override
    @Nullable
    public MemoryJSON getMemory() {
        return this.memory;
    }

    @Override
    @Nullable
    public DatabaseJSON getDatabase() {
        return this.database;
    }

    @Override
    @Nullable
    public Long getServerStartTime() {
        return this.serverStartTime;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = new ArrayList<String>();
        if (aliasIds != null) {
            for (String it : aliasIds) {
                this.aliasIds.add(it);
            }
        }
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = new ArrayList<AliasJSON>();
        if (aliases != null) {
            for (AliasJSON it : aliases) {
                this.aliases.add(it);
            }
        }
    }

    @XmlTransient
    public void setAvailableProcessors(@Nullable Integer availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    @XmlTransient
    public void setMemory(@Nullable MemoryJSON memory) {
        this.memory = memory;
    }

    @XmlTransient
    public void setDatabase(@Nullable DatabaseJSON database) {
        this.database = database;
    }

    @XmlTransient
    public void setServerStartTime(@Nullable Long serverStartTime) {
        this.serverStartTime = serverStartTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics that = (Metrics)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static MetricsJSON wrap(@NotNull Metrics that) {
        if (that instanceof MetricsJSON) {
            return (MetricsJSON)that;
        }
        return new MetricsJSON(that);
    }
}

