/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.ProjectTeamMember;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.authority.VCSUserName;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.AvatarJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.VcsUserNameJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="projectTeamMember")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ProjectTeamMemberJSON.class)
@JsonTypeName(value="projectTeamMember")
public class ProjectTeamMemberJSON
extends UserJSON
implements ProjectTeamMember {
    @XmlElement(name="teamOwnUser")
    private Boolean teamOwnUser;
    @XmlElement(name="teamGroups")
    private List<UserGroupJSON> teamGroups;

    public ProjectTeamMemberJSON() {
    }

    public ProjectTeamMemberJSON(@NotNull ProjectTeamMember that) {
        IdItem ref;
        ArrayList<UserGroupJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setLogin(that.getLogin());
        this.setBanned(that.isBanned());
        this.setBanReason(that.getBanReason());
        this.setGuest(that.isGuest());
        if (that.getAvatar() != null) {
            this.setAvatar(new AvatarJSON(that.getAvatar()));
        }
        if (that.getProfile() != null) {
            this.setProfile(new ProfileJSON(that.getProfile()));
        }
        if (that.getGroups() != null) {
            references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(userGroup.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setGroups(references);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (ProjectTeam projectTeam : that.getTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(projectTeam.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeams(references);
        }
        if (that.getTransitiveTeams() != null) {
            references = new ArrayList();
            for (ProjectTeam projectTeam : that.getTransitiveTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(projectTeam.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveTeams(references);
        }
        if (that.getDetails() != null) {
            aggregated = new ArrayList();
            for (UserDetails userDetails : that.getDetails()) {
                aggregated.add((AliasJSON)((Object)new DetailsJSON(userDetails)));
            }
            this.setDetails(aggregated);
        }
        if (that.getVCSUserNames() != null) {
            aggregated = new ArrayList();
            for (VCSUserName vCSUserName : that.getVCSUserNames()) {
                aggregated.add((AliasJSON)((Object)new VcsUserNameJSON(vCSUserName)));
            }
            this.setVCSUserNames(aggregated);
        }
        if (that.getLicenses() != null) {
            references = new ArrayList();
            for (LicenseSettings licenseSettings : that.getLicenses()) {
                ref = new LicenseJSON();
                ((SettingsJSON)ref).setId(licenseSettings.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setLicenses(references);
        }
        this.setCreationTime(that.getCreationTime());
        this.setLastAccessTime(that.getLastAccessTime());
        if (that.getRefreshTokens() != null) {
            aggregated = new ArrayList();
            for (RefreshToken refreshToken : that.getRefreshTokens()) {
                aggregated.add((AliasJSON)((Object)new RefreshTokenJSON(refreshToken)));
            }
            this.setRefreshTokens(aggregated);
        }
        if (that.getPermanentTokens() != null) {
            aggregated = new ArrayList();
            for (PermanentToken permanentToken : that.getPermanentTokens()) {
                aggregated.add((AliasJSON)((Object)new PermanentTokenJSON(permanentToken)));
            }
            this.setPermanentTokens(aggregated);
        }
        if (that.getApprovedScopes() != null) {
            aggregated = new ArrayList();
            for (ApprovedScope approvedScope : that.getApprovedScopes()) {
                aggregated.add((AliasJSON)((Object)new ApprovedScopeJSON(approvedScope)));
            }
            this.setApprovedScopes(aggregated);
        }
        if (that.getFavoriteProjects() != null) {
            references = new ArrayList();
            for (Project project : that.getFavoriteProjects()) {
                ref = new ProjectJSON();
                ((ProjectJSON)ref).setId(project.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setFavoriteProjects(references);
        }
        this.setTeamOwnUser(that.isTeamOwnUser());
        if (that.getTeamGroups() != null) {
            references = new ArrayList();
            for (UserGroup userGroup : that.getTeamGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(userGroup.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeamGroups(references);
        }
    }

    @Override
    @Nullable
    public Boolean isTeamOwnUser() {
        return this.teamOwnUser;
    }

    @Nullable
    public Iterable<UserGroupJSON> getTeamGroups() {
        return this.teamGroups;
    }

    @XmlTransient
    public void setTeamOwnUser(@Nullable Boolean teamOwnUser) {
        this.teamOwnUser = teamOwnUser;
    }

    @XmlTransient
    public void setTeamGroups(@Nullable Iterable<UserGroupJSON> teamGroups) {
        this.teamGroups = new ArrayList<UserGroupJSON>();
        if (teamGroups != null) {
            for (UserGroupJSON it : teamGroups) {
                this.teamGroups.add(it);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectTeamMember)) {
            return false;
        }
        ProjectTeamMember that = (ProjectTeamMember)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectTeamMemberJSON wrap(@NotNull ProjectTeamMember that) {
        if (that instanceof ProjectTeamMemberJSON) {
            return (ProjectTeamMemberJSON)that;
        }
        return new ProjectTeamMemberJSON(that);
    }
}

