/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementJSON;
import jetbrains.jetpass.rest.dto.LocaleJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="publicSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="public")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=PublicSettingsJSON.class)
public class PublicSettingsJSON
extends SettingsJSON
implements PublicSettings {
    @XmlElement(name="locale")
    private LocaleJSON locale;
    @XmlElement(name="hubMottoHidden")
    private Boolean hubMottoHidden;
    @XmlElement(name="companyLogo")
    private String companyLogo;
    @XmlElement(name="systemMessage")
    private String systemMessage;
    @XmlElement(name="endUserAgreement")
    private EndUserAgreementJSON endUserAgreement;
    @XmlElement(name="installationType")
    private String installationType;
    @XmlElement(name="emailVerificationRequired")
    private Boolean emailVerificationRequired;

    public PublicSettingsJSON() {
    }

    public PublicSettingsJSON(@NotNull PublicSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getLocale() != null) {
            this.setLocale(new LocaleJSON(that.getLocale()));
        }
        this.setHubMottoHidden(that.isHubMottoHidden());
        this.setCompanyLogo(that.getCompanyLogo());
        this.setSystemMessage(that.getSystemMessage());
        if (that.getEndUserAgreement() != null) {
            this.setEndUserAgreement(EndUserAgreementJSON.wrap(that.getEndUserAgreement()));
        }
        this.setInstallationType(that.getInstallationType());
        this.setEmailVerificationRequired(that.isEmailVerificationRequired());
    }

    @Override
    @Nullable
    public LocaleJSON getLocale() {
        return this.locale;
    }

    @Override
    @Nullable
    public Boolean isHubMottoHidden() {
        return this.hubMottoHidden;
    }

    @Override
    @Nullable
    public String getCompanyLogo() {
        return this.companyLogo;
    }

    @Override
    @Nullable
    public String getSystemMessage() {
        return this.systemMessage;
    }

    @Override
    public EndUserAgreementJSON getEndUserAgreement() {
        return this.endUserAgreement;
    }

    @Override
    @Nullable
    public String getInstallationType() {
        return this.installationType;
    }

    @Override
    @Nullable
    public Boolean isEmailVerificationRequired() {
        return this.emailVerificationRequired;
    }

    @XmlTransient
    public void setLocale(@Nullable LocaleJSON locale) {
        this.locale = locale;
    }

    @XmlTransient
    public void setHubMottoHidden(@Nullable Boolean hubMottoHidden) {
        this.hubMottoHidden = hubMottoHidden;
    }

    @XmlTransient
    public void setCompanyLogo(@Nullable String companyLogo) {
        this.companyLogo = companyLogo;
    }

    @XmlTransient
    public void setSystemMessage(@Nullable String systemMessage) {
        this.systemMessage = systemMessage;
    }

    @XmlTransient
    public void setEndUserAgreement(EndUserAgreementJSON endUserAgreement) {
        this.endUserAgreement = endUserAgreement;
    }

    @XmlTransient
    public void setInstallationType(@Nullable String installationType) {
        this.installationType = installationType;
    }

    @XmlTransient
    public void setEmailVerificationRequired(Boolean emailVerificationRequired) {
        this.emailVerificationRequired = emailVerificationRequired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicSettings)) {
            return false;
        }
        PublicSettings that = (PublicSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static PublicSettingsJSON wrap(@NotNull PublicSettings that) {
        if (that instanceof PublicSettingsJSON) {
            return (PublicSettingsJSON)that;
        }
        return new PublicSettingsJSON(that);
    }
}

