/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.authority.VCSUserName;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.AvatarJSON;
import jetbrains.jetpass.rest.dto.ContactJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementConsentJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SshPublicKeyJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.VcsUserNameJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserJSON.class)
@JsonTypeName(value="user")
public class UserJSON
extends AuthorityHolderJSON
implements User {
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="banned")
    private Boolean banned;
    @XmlElement(name="banReason")
    private String banReason;
    @XmlElement(name="guest")
    private Boolean guest;
    @XmlElement(name="avatar")
    private AvatarJSON avatar;
    @XmlElement(name="profile")
    private ProfileJSON profile;
    @XmlElement(name="contacts")
    private List<ContactJSON> contacts;
    @XmlElement(name="groups")
    private List<UserGroupJSON> groups;
    @XmlElement(name="teams")
    private List<ProjectTeamJSON> teams;
    @XmlElement(name="transitiveTeams")
    private List<ProjectTeamJSON> transitiveTeams;
    @XmlElement(name="details")
    private List<DetailsJSON> details;
    @XmlElement(name="VCSUserNames")
    private List<VcsUserNameJSON> VCSUserNames;
    @XmlElement(name="sshPublicKeys")
    private List<SshPublicKeyJSON> sshPublicKeys;
    @XmlElement(name="licenses")
    private List<LicenseJSON> licenses;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="lastAccessTime")
    private Calendar lastAccessTime;
    @XmlElement(name="refreshTokens")
    private List<RefreshTokenJSON> refreshTokens;
    @XmlElement(name="permanentTokens")
    private List<PermanentTokenJSON> permanentTokens;
    @XmlElement(name="approvedScopes")
    private List<ApprovedScopeJSON> approvedScopes;
    @XmlElement(name="favoriteProjects")
    private List<ProjectJSON> favoriteProjects;
    @XmlElement(name="endUserAgreementConsent")
    private EndUserAgreementConsentJSON endUserAgreementConsent;

    public UserJSON() {
    }

    public UserJSON(@NotNull User that) {
        IdItem ref;
        ArrayList<UserGroupJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setLogin(that.getLogin());
        this.setBanned(that.isBanned());
        this.setBanReason(that.getBanReason());
        this.setGuest(that.isGuest());
        if (that.getAvatar() != null) {
            this.setAvatar(new AvatarJSON(that.getAvatar()));
        }
        if (that.getProfile() != null) {
            this.setProfile(new ProfileJSON(that.getProfile()));
        }
        if (that.getGroups() != null) {
            references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(userGroup.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setGroups(references);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (ProjectTeam projectTeam : that.getTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(projectTeam.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeams(references);
        }
        if (that.getTransitiveTeams() != null) {
            references = new ArrayList();
            for (ProjectTeam projectTeam : that.getTransitiveTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(projectTeam.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveTeams(references);
        }
        if (that.getDetails() != null) {
            aggregated = new ArrayList();
            for (UserDetails userDetails : that.getDetails()) {
                aggregated.add((AliasJSON)((Object)new DetailsJSON(userDetails)));
            }
            this.setDetails(aggregated);
        }
        if (that.getVCSUserNames() != null) {
            aggregated = new ArrayList();
            for (VCSUserName vCSUserName : that.getVCSUserNames()) {
                aggregated.add((AliasJSON)((Object)new VcsUserNameJSON(vCSUserName)));
            }
            this.setVCSUserNames(aggregated);
        }
        if (that.getLicenses() != null) {
            references = new ArrayList();
            for (LicenseSettings licenseSettings : that.getLicenses()) {
                ref = new LicenseJSON();
                ((SettingsJSON)ref).setId(licenseSettings.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setLicenses(references);
        }
        this.setCreationTime(that.getCreationTime());
        this.setLastAccessTime(that.getLastAccessTime());
        if (that.getRefreshTokens() != null) {
            aggregated = new ArrayList();
            for (RefreshToken refreshToken : that.getRefreshTokens()) {
                aggregated.add((AliasJSON)((Object)new RefreshTokenJSON(refreshToken)));
            }
            this.setRefreshTokens(aggregated);
        }
        if (that.getPermanentTokens() != null) {
            aggregated = new ArrayList();
            for (PermanentToken permanentToken : that.getPermanentTokens()) {
                aggregated.add((AliasJSON)((Object)new PermanentTokenJSON(permanentToken)));
            }
            this.setPermanentTokens(aggregated);
        }
        if (that.getApprovedScopes() != null) {
            aggregated = new ArrayList();
            for (ApprovedScope approvedScope : that.getApprovedScopes()) {
                aggregated.add((AliasJSON)((Object)new ApprovedScopeJSON(approvedScope)));
            }
            this.setApprovedScopes(aggregated);
        }
        if (that.getFavoriteProjects() != null) {
            references = new ArrayList();
            for (Project project : that.getFavoriteProjects()) {
                ref = new ProjectJSON();
                ((ProjectJSON)ref).setId(project.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setFavoriteProjects(references);
        }
        if (that.getEndUserAgreementConsent() != null) {
            this.setEndUserAgreementConsent(EndUserAgreementConsentJSON.wrap(that.getEndUserAgreementConsent()));
        }
    }

    @Override
    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Override
    @Nullable
    public Boolean isBanned() {
        return this.banned;
    }

    @Override
    @Nullable
    public String getBanReason() {
        return this.banReason;
    }

    @Override
    @Nullable
    public Boolean isGuest() {
        return this.guest;
    }

    @Override
    @Nullable
    public AvatarJSON getAvatar() {
        return this.avatar;
    }

    @Override
    @Nullable
    public ProfileJSON getProfile() {
        return this.profile;
    }

    @Nullable
    public Iterable<ContactJSON> getContacts() {
        return this.contacts;
    }

    @Nullable
    public Iterable<UserGroupJSON> getGroups() {
        return this.groups;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTeams() {
        return this.teams;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTransitiveTeams() {
        return this.transitiveTeams;
    }

    @Nullable
    public Iterable<DetailsJSON> getDetails() {
        return this.details;
    }

    @Nullable
    public Iterable<VcsUserNameJSON> getVCSUserNames() {
        return this.VCSUserNames;
    }

    @Nullable
    public Iterable<SshPublicKeyJSON> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    @Nullable
    public Iterable<LicenseJSON> getLicenses() {
        return this.licenses;
    }

    @Override
    @Nullable
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nullable
    public Calendar getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Nullable
    public Iterable<RefreshTokenJSON> getRefreshTokens() {
        return this.refreshTokens;
    }

    @Nullable
    public Iterable<PermanentTokenJSON> getPermanentTokens() {
        return this.permanentTokens;
    }

    @Nullable
    public Iterable<ApprovedScopeJSON> getApprovedScopes() {
        return this.approvedScopes;
    }

    @Nullable
    public Iterable<ProjectJSON> getFavoriteProjects() {
        return this.favoriteProjects;
    }

    @Override
    public EndUserAgreementConsentJSON getEndUserAgreementConsent() {
        return this.endUserAgreementConsent;
    }

    @XmlTransient
    public void setLogin(@Nullable String login2) {
        this.login = login2;
    }

    @XmlTransient
    public void setBanned(@Nullable Boolean banned) {
        this.banned = banned;
    }

    @XmlTransient
    public void setBanReason(@Nullable String banReason) {
        this.banReason = banReason;
    }

    @XmlTransient
    public void setGuest(@Nullable Boolean guest) {
        this.guest = guest;
    }

    @XmlTransient
    public void setAvatar(@Nullable AvatarJSON avatar) {
        this.avatar = avatar;
    }

    @XmlTransient
    public void setProfile(@Nullable ProfileJSON profile) {
        this.profile = profile;
    }

    @XmlTransient
    public void setContacts(@Nullable Iterable<ContactJSON> contacts) {
        this.contacts = new ArrayList<ContactJSON>();
        if (contacts != null) {
            for (ContactJSON it : contacts) {
                this.contacts.add(it);
            }
        }
    }

    @XmlTransient
    public void setGroups(@Nullable Iterable<UserGroupJSON> groups2) {
        this.groups = new ArrayList<UserGroupJSON>();
        if (groups2 != null) {
            for (UserGroupJSON it : groups2) {
                this.groups.add(it);
            }
        }
    }

    @XmlTransient
    public void setTeams(@Nullable Iterable<ProjectTeamJSON> teams) {
        this.teams = new ArrayList<ProjectTeamJSON>();
        if (teams != null) {
            for (ProjectTeamJSON it : teams) {
                this.teams.add(it);
            }
        }
    }

    @XmlTransient
    public void setTransitiveTeams(@Nullable Iterable<ProjectTeamJSON> transitiveTeams) {
        this.transitiveTeams = new ArrayList<ProjectTeamJSON>();
        if (transitiveTeams != null) {
            for (ProjectTeamJSON it : transitiveTeams) {
                this.transitiveTeams.add(it);
            }
        }
    }

    @XmlTransient
    public void setDetails(@Nullable Iterable<DetailsJSON> details) {
        this.details = new ArrayList<DetailsJSON>();
        if (details != null) {
            for (DetailsJSON it : details) {
                this.details.add(it);
            }
        }
    }

    @XmlTransient
    public void setVCSUserNames(@Nullable Iterable<VcsUserNameJSON> VCSUserNames) {
        this.VCSUserNames = new ArrayList<VcsUserNameJSON>();
        if (VCSUserNames != null) {
            for (VcsUserNameJSON it : VCSUserNames) {
                this.VCSUserNames.add(it);
            }
        }
    }

    @XmlTransient
    public void setSshPublicKeys(@Nullable Iterable<SshPublicKeyJSON> sshPublicKeys) {
        this.sshPublicKeys = new ArrayList<SshPublicKeyJSON>();
        if (sshPublicKeys != null) {
            for (SshPublicKeyJSON it : sshPublicKeys) {
                this.sshPublicKeys.add(it);
            }
        }
    }

    @XmlTransient
    public void setLicenses(@Nullable Iterable<LicenseJSON> licenses) {
        this.licenses = new ArrayList<LicenseJSON>();
        if (licenses != null) {
            for (LicenseJSON it : licenses) {
                this.licenses.add(it);
            }
        }
    }

    @XmlTransient
    public void setCreationTime(@Nullable Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @XmlTransient
    public void setLastAccessTime(@Nullable Calendar lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @XmlTransient
    public void setRefreshTokens(@Nullable Iterable<RefreshTokenJSON> refreshTokens) {
        this.refreshTokens = new ArrayList<RefreshTokenJSON>();
        if (refreshTokens != null) {
            for (RefreshTokenJSON it : refreshTokens) {
                this.refreshTokens.add(it);
            }
        }
    }

    @XmlTransient
    public void setPermanentTokens(@Nullable Iterable<PermanentTokenJSON> permanentTokens) {
        this.permanentTokens = new ArrayList<PermanentTokenJSON>();
        if (permanentTokens != null) {
            for (PermanentTokenJSON it : permanentTokens) {
                this.permanentTokens.add(it);
            }
        }
    }

    @XmlTransient
    public void setApprovedScopes(@Nullable Iterable<ApprovedScopeJSON> approvedScopes) {
        this.approvedScopes = new ArrayList<ApprovedScopeJSON>();
        if (approvedScopes != null) {
            for (ApprovedScopeJSON it : approvedScopes) {
                this.approvedScopes.add(it);
            }
        }
    }

    @XmlTransient
    public void setFavoriteProjects(@Nullable Iterable<ProjectJSON> favoriteProjects) {
        this.favoriteProjects = new ArrayList<ProjectJSON>();
        if (favoriteProjects != null) {
            for (ProjectJSON it : favoriteProjects) {
                this.favoriteProjects.add(it);
            }
        }
    }

    @XmlTransient
    public void setEndUserAgreementConsent(EndUserAgreementConsentJSON endUserAgreementConsent) {
        this.endUserAgreementConsent = endUserAgreementConsent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User that = (User)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserJSON wrap(@NotNull User that) {
        if (that instanceof UserJSON) {
            return (UserJSON)that;
        }
        return new UserJSON(that);
    }
}

