/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import sun.util.ResourceBundleEnumeration;

public abstract class OpenListResourceBundle
extends ResourceBundle {
    private volatile Map<String, Object> lookup = null;
    private volatile Set<String> keyset;

    protected OpenListResourceBundle() {
    }

    @Override
    protected Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle resourceBundle = this.parent;
        return new ResourceBundleEnumeration(this.handleKeySet(), resourceBundle != null ? resourceBundle.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        if (this.keyset != null) {
            return this.keyset;
        }
        Set<String> set = this.createSet();
        set.addAll(this.handleKeySet());
        if (this.parent != null) {
            set.addAll(this.parent.keySet());
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.keyset == null) {
                this.keyset = set;
            }
        }
        return this.keyset;
    }

    protected abstract Object[][] getContents();

    void loadLookupTablesIfNecessary() {
        if (this.lookup == null) {
            this.loadLookup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLookup() {
        Object[][] objectArray = this.getContents();
        Map<String, Object> map = this.createMap(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][0];
            Object object = objectArray[i][1];
            if (string == null || object == null) {
                throw new NullPointerException();
            }
            map.put(string, object);
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.lookup == null) {
                this.lookup = map;
            }
        }
    }

    protected <K, V> Map<K, V> createMap(int n) {
        return new HashMap(n);
    }

    protected <E> Set<E> createSet() {
        return new HashSet();
    }
}

