/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;

public class LongConverter
extends FixedClassConverter {
    public LongConverter() {
        super(Long.TYPE);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Long)value);
    }

    private String doToString(long value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        try {
            return valueAsString == null ? 0L : Long.parseLong(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.long_converter_format_exception", valueAsString);
        }
    }
}

