/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.mps.webr.runtime.converter.TypeConverter;

public class TypeConvertManager {
    private List<TypeConverter> myTypeConverters;
    private ConcurrentMap<String, TypeConverter> myTypeConvertersCache = new ConcurrentHashMap<String, TypeConverter>();

    public void setTypeConverters(List<TypeConverter> typeConverters) {
        this.myTypeConverters = typeConverters;
    }

    public String toString(Object value) {
        String valueAsString = "";
        if (value != null) {
            String typeName = value.getClass().getName();
            valueAsString = this.getTypeConverter(typeName).toString(value);
        }
        return valueAsString;
    }

    public Object fromString(String valueAsString, String typeName) {
        return this.getTypeConverter(typeName).fromString(typeName, valueAsString);
    }

    private TypeConverter getTypeConverter(String typeName) {
        TypeConverter typeConverter = (TypeConverter)this.myTypeConvertersCache.get(typeName);
        if (typeConverter != null) {
            return typeConverter;
        }
        for (TypeConverter tc : this.myTypeConverters) {
            if (!tc.accepts(typeName)) continue;
            this.myTypeConvertersCache.putIfAbsent(typeName, tc);
            return tc;
        }
        throw new UnsupportedOperationException("Can't convert " + typeName);
    }
}

