/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.freemarker;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.webr.runtime.cache.CacheControlUtil;
import jetbrains.mps.webr.runtime.freemarker.FreemarkerMethod;
import jetbrains.mps.webr.runtime.freemarker.GetBaseUrl;
import jetbrains.mps.webr.runtime.freemarker.GetClasspathUriMethod;
import jetbrains.mps.webr.runtime.freemarker.GetDeferredClasspathUriMethod;
import jetbrains.mps.webr.runtime.freemarker.GetDeferredStylesheetUriMethod;
import jetbrains.mps.webr.runtime.freemarker.GetInlineClassIdMethod;
import jetbrains.mps.webr.runtime.freemarker.GetJsProgramUriMethod;
import jetbrains.mps.webr.runtime.freemarker.GetPrincipalCookie;
import jetbrains.mps.webr.runtime.freemarker.GetRequestParameter;
import jetbrains.mps.webr.runtime.freemarker.GetStylesheetUriMethod;
import jetbrains.mps.webr.runtime.freemarker.ImportCssMethod;
import jetbrains.mps.webr.runtime.freemarker.LocalizeMessage;
import jetbrains.mps.webr.runtime.freemarker.PreprocessCssUrlsDirective;
import jetbrains.mps.webr.runtime.freemarker.UseResouceBundleMethod;
import jetbrains.mps.webr.runtime.uri.hash.HashFileNameUtil;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;

public final class FreemarkerResponse
implements ResponseAction {
    public static final Object ROOT_MAP = FreemarkerResponse.getRootMap();
    private final String myResourcePath;

    public FreemarkerResponse(String resourcePath) {
        this.myResourcePath = HashFileNameUtil.getPath(resourcePath);
    }

    @Override
    public final void doAction(HttpServletResponse response) throws IOException {
        try {
            Template template = BaseApplication.getCentralManager().getFreemarkerConfiguration().getTemplate(this.myResourcePath);
            response.setContentType(BaseApplication.getServletContext().getMimeType(this.myResourcePath));
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            CacheControlUtil.setHeaders(response, true);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
            template.process(ROOT_MAP, (Writer)writer);
            writer.flush();
        }
        catch (FileNotFoundException e1) {
            response.sendError(404, "Resource [" + this.myResourcePath + "] was not found");
        }
        catch (TemplateException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static Object getRootMap() {
        FreemarkerMethod[] freemarkerMethods;
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        for (FreemarkerMethod freemarkerMethod : freemarkerMethods = new FreemarkerMethod[]{new GetClasspathUriMethod(), new GetDeferredClasspathUriMethod(), new GetStylesheetUriMethod(), new GetDeferredStylesheetUriMethod(), new GetJsProgramUriMethod(), new ImportCssMethod(), new UseResouceBundleMethod(), new GetRequestParameter(), new GetBaseUrl(), new GetPrincipalCookie(), new GetInlineClassIdMethod(), new LocalizeMessage()}) {
            rootMap.put(freemarkerMethod.getMethodName(), freemarkerMethod);
        }
        rootMap.put("preprocessCssUrls", new PreprocessCssUrlsDirective());
        return rootMap;
    }
}

