/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.mps.webr.runtime.listeners.LocalEventsMultiplexerProxy;

public class LocalEventMultiplexerProxyImpl
implements LocalEventsMultiplexerProxy {
    private final Map<String, Queue<IEntityListener>> typeToListeners = new HashMap<String, Queue<IEntityListener>>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(String entityType, IEntityListener listener) {
        this.rwl.writeLock().lock();
        try {
            Queue<IEntityListener> listeners = this.typeToListeners.get(entityType);
            if (listeners == null) {
                listeners = new ConcurrentLinkedQueue<IEntityListener>();
                this.typeToListeners.put(entityType, listeners);
            }
            listeners.add(listener);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(String entityType, IEntityListener listener) {
        this.rwl.writeLock().lock();
        try {
            Queue<IEntityListener> listeners = this.typeToListeners.get(entityType);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.typeToListeners.remove(entityType);
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IEntityListener> getListeners(String entityType) {
        this.rwl.readLock().lock();
        try {
            Iterable iterable = this.typeToListeners.get(entityType);
            return iterable;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

