/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.plaintext;

import java.util.LinkedList;
import jetbrains.mps.webr.runtime.plaintext.TableRenderer;
import org.htmlparser.Tag;
import org.htmlparser.beans.StringBean;
import org.htmlparser.tags.Bullet;
import org.htmlparser.tags.BulletList;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.TableTag;

public class SmartStringBean
extends StringBean {
    private LinkedList<ListItem> myListItems = new LinkedList();
    private boolean myRenderingTable = false;

    public void visitTag(Tag tag) {
        this.myRenderingTable = false;
        if (tag instanceof BulletList) {
            String name = tag.getTagName();
            if ("OL".equalsIgnoreCase(name)) {
                this.push(ListType.OL);
            } else if ("UL".equalsIgnoreCase(name)) {
                this.push(ListType.UL);
            }
        } else if (tag instanceof TableTag) {
            this.carriageReturn();
            TableRenderer tableRenderer = new TableRenderer((TableTag)tag);
            tableRenderer.print(this.mBuffer);
            this.myRenderingTable = true;
        } else if (tag instanceof Bullet) {
            this.printBullet();
        } else if (tag instanceof LinkTag) {
            if (this.getLinks()) {
                this.mBuffer.append("< ");
                this.mBuffer.append(((LinkTag)tag).getLink());
                this.mBuffer.append(" >");
            }
        } else {
            super.visitTag(tag);
        }
    }

    public void visitEndTag(Tag tag) {
        this.myRenderingTable = false;
        if ("OL".equalsIgnoreCase(tag.getTagName())) {
            this.pop();
        } else if ("UL".equalsIgnoreCase(tag.getTagName())) {
            this.pop();
        } else {
            super.visitEndTag(tag);
        }
    }

    public boolean shouldRecurseChildren() {
        return !this.myRenderingTable;
    }

    protected void push(ListType type) {
        this.myListItems.addLast(new ListItem(type));
    }

    protected void pop() {
        if (!this.myListItems.isEmpty()) {
            this.myListItems.removeLast();
        }
    }

    protected void printBullet() {
        this.carriageReturn();
        for (int i = 0; i < this.myListItems.size() - 1; ++i) {
            this.mBuffer.append("  ");
        }
        if (!this.myListItems.isEmpty()) {
            ListItem lastItem = this.myListItems.getLast();
            switch (lastItem.myType) {
                case OL: {
                    this.mBuffer.append(lastItem.myItemNumber).append(". ");
                    break;
                }
                case UL: {
                    this.mBuffer.append("* ");
                }
            }
            ++lastItem.myItemNumber;
        }
    }

    private static class ListItem {
        ListType myType;
        int myItemNumber = 1;

        public ListItem(ListType type) {
            this.myType = type;
        }
    }

    private static enum ListType {
        UL,
        OL;

    }
}

