/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.ErrorMessageManager;
import webr.framework.runtime.response.CommandResponseAction;
import webr.framework.runtime.response.CommandScriptor;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TBuilderContext;

public class JsResponseFactory
extends ResponseFactory {
    private static String AUTO_RELOAD = "jetbrains.mps.webr.autoReload";
    protected static Log log = LogFactory.getLog(JsResponseFactory.class);

    protected JsResponseFactory() {
    }

    public CommandResponseAction getEvalResponse(final String script) {
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append(script);
                builderContext.append(";");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    @Override
    public ResponseAction getNotFoundResponse(String message) {
        if (log.isErrorEnabled()) {
            log.error((Object)message);
        }
        return this.getShowErrorResponse(message);
    }

    @Override
    public CommandResponseAction getForbiddenResponse(String message) {
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
        return this.getShowErrorResponse(message);
    }

    @Override
    public ResponseAction getInternalServerErrorResponse(String message) {
        if (log.isErrorEnabled()) {
            log.error((Object)message);
        }
        return this.getShowErrorResponse(message);
    }

    @Override
    public ResponseAction getRedirectSelfResponse() {
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.Event.reload();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    private CommandResponseAction getShowErrorResponse(final String message) {
        CommandResponseAction responseAction = CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"message\" clear=\"");
                builderContext.append(true);
                builderContext.append("\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("[{message: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", severity: Webr.ErrorMessage.ERROR}];");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
        return responseAction;
    }

    public CommandResponseAction getReconnectedResponse() {
        CommandResponseAction responseAction;
        Integer maxSecondsToWait = Integer.getInteger(AUTO_RELOAD);
        if (maxSecondsToWait != null) {
            int minSecondsToWait = 10;
            final int secondsToWait = (int)((double)minSecondsToWait + (double)(maxSecondsToWait - minSecondsToWait) * Math.random());
            responseAction = CommandResponseAction.create(new CommandScriptor(){

                @Override
                public void generateScript(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<command type=\"execute\" clear=\"");
                    builderContext.append(true);
                    builderContext.append("\"><![CDATA[");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("Webr.event.ResponseServerEventListener.reloadDelayed(");
                    builderContext.append(String.valueOf(secondsToWait));
                    builderContext.append(");");
                    builderContext.appendNewLine();
                    builderContext.appendNewLine();
                    builderContext.append("]]></command>");
                    builderContext.appendNewLine();
                }
            }, false);
        } else {
            responseAction = CommandResponseAction.create(new CommandScriptor(){

                @Override
                public void generateScript(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<command type=\"execute\" clear=\"");
                    builderContext.append(true);
                    builderContext.append("\"><![CDATA[");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("Webr.event.ResponseServerEventListener.disconnectedMessage(\"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JsResponseFactory.Connection_Restored_{Reload_now}", new Object[]{"<a href=\"javascript:reload();\">" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("JsResponseFactory.Reload_now", new Object[0]) + "</a>"})));
                    builderContext.append("\");");
                    builderContext.appendNewLine();
                    builderContext.appendNewLine();
                    builderContext.append("]]></command>");
                    builderContext.appendNewLine();
                }
            }, false);
        }
        return responseAction;
    }

    @Override
    public ResponseAction getDefaultResponse() {
        return this.getDoNothingResponse();
    }

    @Override
    public ResponseAction getDoNothingResponse() {
        CommandResponseAction responseAction;
        if (!ErrorMessageManager.isEmpty()) {
            responseAction = this.getShowErrorMessagesResponse(ErrorMessageManager.getMessages());
            ErrorMessageManager.clearMessages();
        } else {
            responseAction = CommandResponseAction.create(new CommandScriptor(){

                @Override
                public void generateScript(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<command type=\"execute\"><![CDATA[");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("\"JetBrains rulez\";");
                    builderContext.appendNewLine();
                    builderContext.appendNewLine();
                    builderContext.append("]]></command>");
                    builderContext.appendNewLine();
                }
            }, false);
        }
        return responseAction;
    }

    public CommandResponseAction getShowErrorMessagesResponse(Iterable<ErrorMessageManager.Message> messages) {
        IListSequence messagesCopy = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)messagesCopy).addSequence(Sequence.fromIterable(messages));
        CommandResponseAction responseAction = CommandResponseAction.create(new CommandScriptor((List)messagesCopy){
            final /* synthetic */ List val$messagesCopy;
            {
                this.val$messagesCopy = list;
            }

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"message\" clear=\"");
                builderContext.append(true);
                builderContext.append("\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("[");
                boolean first = true;
                for (ErrorMessageManager.Message message : ListSequence.fromList((List)this.val$messagesCopy)) {
                    if (!first) {
                        builderContext.append(",");
                    } else {
                        first = false;
                    }
                    builderContext.append("{message: \"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)String.valueOf(message.getMessage())));
                    builderContext.append("\", severity: \"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)message.getSeverity().getStyleClass()));
                    builderContext.append("\", inputName: \"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)(message.getInputName() != null ? message.getInputName() : "")));
                    builderContext.append("\", propertyName: \"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)message.getPropertyName()));
                    builderContext.append("\"}");
                }
                builderContext.append("];");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
        return responseAction;
    }

    @Override
    public ResponseAction getRedirectResponse(final String actionUrl) {
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.Event.redirect(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)actionUrl));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }
}

