/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.webr.runtime.cache.CacheControlUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.resource.ResourceBundle;
import jetbrains.mps.webr.runtime.resource.ResourceBundleManager;
import jetbrains.mps.webr.runtime.url.RequestUri;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class ResourceBundleRequestProcessor
implements RequestProcessor {
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String expectedController;
        String actualController = requestUri.getElement(0);
        return actualController == (expectedController = "_resourceBundle") || actualController != null && actualController.equalsIgnoreCase(expectedController);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        String path = null;
        final Wrappers._T rb = new Wrappers._T(null);
        if (ResourceBundleRequestProcessor.isEmpty_9w16s9_a0c0d(requestUri.getTail(1))) {
            path = requestUri.getTail(0);
            rb.value = null;
        } else {
            path = requestUri.getTail(1).substring(1);
            rb.value = ResourceBundleManager.getInstance().getResourceBundle(path);
        }
        if (rb.value == null) {
            return ResponseFactory.getInstance().getNotFoundResponse("Resource bundle with path [" + path + "] is not found.");
        }
        ResponseAction action = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                response.setContentType(((ResourceBundle)rb.value).getMimeType());
                response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
                CacheControlUtil.setHeaders(response, true);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
                ((ResourceBundle)rb.value).writeTo(writer);
                writer.flush();
            }
        };
        return action;
    }

    public static boolean isEmpty_9w16s9_a0c0d(String str) {
        return str == null || str.length() == 0;
    }
}

