/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.resource;

import eu.medsea.mimeutil.MimeUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.freemarker.FreemarkerResponse;
import jetbrains.mps.webr.runtime.servlet.ResourceWrapper;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class Resource {
    private static final String[] MIN_SUFFIXES = new String[]{"-min.", ".min."};
    private static final StringInterner CONTENT_INTERNER = StringInterner.newInterner((int)1563);
    protected static Log log = LogFactory.getLog(Resource.class);
    private long lastModified;
    private String content;
    private String mimeType;
    private String resourcePath;
    private boolean needPreprocessing;

    public Resource(UrlGetter resourcePath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create new resource [" + resourcePath.getResourcePath() + "]"));
        }
        try (ResourceWrapper wrapper = null;){
            this.resourcePath = StringInterner.intern((String)resourcePath.getResourcePath());
            wrapper = this.getWrapper();
            if (wrapper == null) {
                throw new IllegalArgumentException("Can't find resource [" + resourcePath.getResourcePath() + "]");
            }
            this.lastModified = wrapper.lastModified();
            this.mimeType = StringInterner.intern((String)MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((String)resourcePath.getResourcePath())).toString());
            this.needPreprocessing = resourcePath.isNeedPreprocessing();
            this.load(wrapper);
        }
    }

    void writeTo(Writer output) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Write resource to output [" + this.resourcePath + "]"));
        }
        output.write(this.content);
    }

    private void load(ResourceWrapper wrapper) throws IOException {
        this.content = CONTENT_INTERNER.doIntern(this.needPreprocessing ? this.preprocess() : this.loadResource(wrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update() {
        try (ResourceWrapper wrapper = this.getWrapper();){
            if (wrapper.lastModified() != this.lastModified) {
                try {
                    this.load(wrapper);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private ResourceWrapper getWrapper() {
        String fullPath = FilenameUtils.getFullPath((String)this.resourcePath);
        String baseName = FilenameUtils.getBaseName((String)this.resourcePath);
        String ext = FilenameUtils.getExtension((String)this.resourcePath);
        String pathAndName = fullPath + baseName;
        ResourceWrapper wrapper = null;
        String minFilePath = this.resourcePath;
        for (String suffix : MIN_SUFFIXES) {
            minFilePath = pathAndName + suffix + ext;
            wrapper = ServletUtil.getResourceWrapper(minFilePath);
            if (wrapper != null) break;
        }
        if (wrapper != null) {
            this.resourcePath = minFilePath;
        } else {
            wrapper = ServletUtil.getResourceWrapper(this.resourcePath);
        }
        return wrapper;
    }

    String getContent() {
        return this.content;
    }

    String getMimeType() {
        return this.mimeType;
    }

    private String preprocess() {
        try {
            Configuration c = BaseApplication.getCentralManager().getFreemarkerConfiguration();
            Template t = c.getTemplate(this.resourcePath);
            StringWriter sw = new StringWriter();
            t.process(FreemarkerResponse.ROOT_MAP, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String loadResource(ResourceWrapper wrapper) throws IOException {
        return IOUtils.toString((InputStream)wrapper.inputStream(), (String)StandardCharsets.UTF_8.toString());
    }
}

