/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.resource;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.resource.ResourceBundle;
import jetbrains.mps.webr.runtime.resource.ResourceBundleManager;
import jetbrains.mps.webr.runtime.resource.ResourceDescriptor;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.WebrContent;
import webr.framework.url.UrlUtil;

public class ResourceBundleId {
    private Set<UrlGetter> resourcePaths = new LinkedHashSet<UrlGetter>();
    private StringBuilder resourcePathsStringBuilder = new StringBuilder();
    private String resourcePathString = null;
    private String mimeType = null;
    private Locale locale;
    private WebrContent bundleContent;
    private ResourceDescriptor rd;

    public ResourceBundleId(String mimetype, Locale locale, TBuilderContext builderContext) {
        this.mimeType = mimetype;
        this.locale = locale;
        this.resourcePathsStringBuilder.append(this.locale);
        this.rd = ResourceDescriptor.fromMimeType(this.mimeType);
        this.rememberResourceBundleContent(builderContext);
    }

    public void rememberResourceBundleContent(TBuilderContext builderContext) {
        this.bundleContent = builderContext.getCurrentWebrContent();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    ResourceDescriptor getResourceDescriptor() {
        return this.rd;
    }

    public void flushLink() {
        ResourceBundle b = ResourceBundleManager.getInstance().getResourceBundle(this);
        this.insertResourceBundlePath(b.getPath());
        ResourceBundleManager.getInstance().removeThreadLocalResourceBundleId(this);
    }

    private void insertResourceBundlePath(String bundlePath) {
        this.bundleContent.getBuffer().appendIndent();
        this.bundleContent.getBuffer().append(this.rd.startHtml);
        this.bundleContent.getBuffer().append(HtmlStringUtil.html(this.getResourceBundleURL(bundlePath)));
        this.bundleContent.getBuffer().append(this.rd.endHtml);
        this.bundleContent.getBuffer().appendNewLine();
    }

    private String getResourceBundleURL(String bundlePath) {
        UrlUtil.Url u = new UrlUtil.Url();
        u.setIsLocal();
        u.addPathElements("_resourceBundle", bundlePath);
        return u.toString();
    }

    public void add(UrlGetter resourcePath) {
        if (this.resourcePathString != null) {
            throw new IllegalStateException("Can't add resource path after hashCode or equals method call.");
        }
        if (this.resourcePaths.add(resourcePath)) {
            this.resourcePathsStringBuilder.append(resourcePath.getResourcePath());
        }
    }

    public Set<UrlGetter> getResourcePaths() {
        return this.resourcePaths;
    }

    private String getResourcePathString() {
        if (this.resourcePathString == null) {
            this.resourcePathString = this.resourcePathsStringBuilder.toString();
        }
        return this.resourcePathString;
    }

    public int hashCode() {
        return this.getResourcePathString().hashCode();
    }

    public boolean equals(Object o) {
        ResourceBundleId that = ResourceBundleId.as_314kw5_a0a0a11(o, ResourceBundleId.class);
        if (that == null) {
            return false;
        }
        return this.getResourcePathString().equals(that.getResourcePathString());
    }

    private static <T> T as_314kw5_a0a0a11(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

