/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.servlet;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import jetbrains.mps.webr.runtime.servlet.ResourceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public final class ServletUtil {
    private static final Log log = LogFactory.getLog(ServletUtil.class);
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String SERVER_DATA_DIR = "serverDataDir";

    private ServletUtil() {
    }

    public static ResourceWrapper getResourceWrapper(String fileName) {
        try {
            return new ResourceWrapper(BaseApplication.getContextClassLoader(), fileName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getFile(String fileName) {
        return ServletUtil.getFile(BaseApplication.getContextClassLoader(), fileName);
    }

    private static File getFile(ClassLoader cl, String fileName) {
        try {
            URL u = cl.getResource(fileName);
            if (u != null) {
                String decodedFilePath = URLDecoder.decode(u.getFile(), "UTF-8");
                return new File(decodedFilePath);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getHtmlFile(String fileName) {
        String path = ServletUtil.getHtmlServerDataDir();
        File dir = new File(path);
        File file = new File(dir, fileName);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    public static String getHtmlServerDataDir() {
        String serverDataDir = System.getProperty(SERVER_DATA_DIR);
        if (serverDataDir == null) {
            ServletContext servletContext = BaseApplication.getServletContext();
            serverDataDir = servletContext.getRealPath("/");
        }
        return serverDataDir + "/html";
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }
}

