/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.runtime.requestProcessor.WindowManager;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.controller.BaseApplication;

public class WebrSessionListenerImpl {
    private final Map<String, HttpSession> sessions = MapSequence.fromMap(new HashMap());
    private final boolean localScope;

    public WebrSessionListenerImpl() {
        this(false);
    }

    public WebrSessionListenerImpl(boolean localScope) {
        this.localScope = localScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionsCount() {
        Map<String, HttpSession> map = this.sessions;
        synchronized (map) {
            return MapSequence.fromMap(this.sessions).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(String sessionId) {
        Map<String, HttpSession> map = this.sessions;
        synchronized (map) {
            return (HttpSession)MapSequence.fromMap(this.sessions).get((Object)sessionId);
        }
    }

    public int getWindowsCount() {
        final Wrappers._int res = new Wrappers._int(0);
        ListSequence.fromList(this.getCopiedSessions()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<HttpSession>(){

            public void visit(HttpSession it) {
                WindowManager wm = WindowManager.getWindowManager(it);
                res.value = res.value + (wm == null ? 0 : wm.getActionControllersCount());
            }
        });
        return res.value;
    }

    public void forEach(final _FunctionTypes._void_P1_E0<? super HttpSession> f) {
        ListSequence.fromList(this.getCopiedSessions()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<HttpSession>(){

            public void visit(HttpSession it) {
                f.invoke((Object)it);
            }
        });
    }

    public void forEach(_FunctionTypes._return_P1_E0<? extends Boolean, ? super HttpSession> f) {
        for (HttpSession session : ListSequence.fromList(this.getCopiedSessions())) {
            if (((Boolean)f.invoke((Object)session)).booleanValue()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpSession> getCopiedSessions() {
        Map<String, HttpSession> map = this.sessions;
        synchronized (map) {
            return Sequence.fromIterable((Iterable)MapSequence.fromMap(this.sessions).values()).toListSequence();
        }
    }

    public Map<String, Serializable> getSessionBean(HttpSession session) {
        try {
            return BaseApplication.getSessionBean(session);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public void sessionDestroyed(HttpSession session, ServletContext context) {
        this.destroy(session);
    }

    private void destroy(HttpSession session) {
        WindowManager wm = WindowManager.getWindowManager(session);
        if (wm != null) {
            wm.destroy();
        }
        this.unsetServerPrincipal(session);
        this.removeSession(session);
    }

    public void sessionCreated(HttpSession session, ServletContext context) {
        this.create(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(HttpSession session) {
        session.setMaxInactiveInterval(160);
        Map<String, HttpSession> map = this.sessions;
        synchronized (map) {
            MapSequence.fromMap(this.sessions).put((Object)session.getId(), (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(HttpSession session) {
        if (session != null) {
            Map<String, HttpSession> map = this.sessions;
            synchronized (map) {
                MapSequence.fromMap(this.sessions).removeKey((Object)session.getId());
            }
        }
    }

    private void unsetServerPrincipal(HttpSession session) {
        PrincipalManager pm = null;
        try {
            pm = (PrincipalManager)ServiceLocator.getBean((String)"principalManager");
        }
        catch (Exception e) {
            return;
        }
        if (pm == null) {
            return;
        }
        pm.unsetServerPrincipal(session);
    }

    public static WebrSessionListenerImpl getInstance() {
        return (WebrSessionListenerImpl)ServiceLocator.getBean((String)"webrSessionListener");
    }
}

