/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.staticHtml.HtmlCommand;
import jetbrains.mps.webr.runtime.staticHtml.HtmlElement;
import jetbrains.mps.webr.runtime.staticHtml.TextElement;

class IfCommand
implements HtmlCommand {
    private static Pattern ifPattern = Pattern.compile("IF\\s*@(.*)");
    private static Pattern endIfPattern = Pattern.compile("<!--%%\\s*END_IF\\s*-->");
    private Matcher matcher;

    IfCommand() {
    }

    @Override
    public boolean isApplicable(String comment) {
        this.matcher = ifPattern.matcher(comment);
        return this.matcher.matches();
    }

    @Override
    public String process(List<HtmlElement> elements, String textAfter, Map<String, Object> rootMap) {
        String variableName = this.matcher.group(1);
        String value = (String)MapSequence.fromMap(rootMap).get((Object)variableName);
        Matcher matcher = endIfPattern.matcher(textAfter);
        boolean isMatch = matcher.find();
        if (!isMatch) {
            throw new RuntimeException("if block not closed");
        }
        if (value != null && value.length() > 0 && value.equals("true")) {
            ListSequence.fromList(elements).addElement((Object)new TextElement(textAfter.substring(0, matcher.start())));
        }
        return textAfter.substring(matcher.end());
    }
}

