/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;

public final class StaticFtlUtil {
    public static final boolean USE_STATIC_HTML = false;
    private static final Configuration CONFIGURATION;
    private static final Map<String, Object> ROOT_MAP;

    private StaticFtlUtil() {
    }

    public static void putToRootMap(String key, Object object) {
        ROOT_MAP.put(key, object);
    }

    public static String getText(String path) {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("nested", path);
        return StaticFtlUtil.getDefaultLayoutText(null, rootMap);
    }

    public static String getDefaultLayoutText(String text, Map<String, Object> templateParameters) {
        if (text != null) {
            templateParameters.put("nestedText", text);
        }
        try {
            Template template = CONFIGURATION.getTemplate("default_layout.html");
            StringWriter stringWriter = new StringWriter();
            templateParameters.putAll(ROOT_MAP);
            template.process(templateParameters, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ROOT_MAP = new HashMap<String, Object>();
        CONFIGURATION = new Configuration();
        String htmlServerDataDir = ServletUtil.getHtmlServerDataDir();
        try {
            CONFIGURATION.setDirectoryForTemplateLoading(new File(htmlServerDataDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

