/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.SimpleActionController;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.TextBuilder;

public abstract class RssTemplateFactory
extends ActionFactory {
    private String myTemplateName;

    public RssTemplateFactory(String templateName) {
        super(null);
        this.setTemplateName(templateName);
    }

    @Override
    public abstract ActionController createAction(String var1, String var2);

    public String getTemplateName() {
        return this.myTemplateName;
    }

    private void setTemplateName(String value) {
        this.myTemplateName = value;
    }

    public static abstract class RssTemplate
    extends TextBuilder {
        @Override
        protected void doGenerateText(Map<String, Object> rootMap, TBuilderContext builderContext) {
            builderContext.pushCurrentTemplateComponent(new TemplateComponent(null, null, null, rootMap){

                @Override
                protected void renderTemplate(Map<String, Object> templateParameters, TBuilderContext builderContext) {
                    throw new UnsupportedOperationException();
                }
            });
            if (!this.hasAccess(builderContext)) {
                throw new SecurityException();
            }
            this.renderChanel(builderContext);
            builderContext.popCurrentTemplateComponent();
        }

        public boolean hasAccess(TBuilderContext builderContext) {
            return true;
        }

        public abstract void renderChanel(TBuilderContext var1);
    }

    public abstract class RSSAction
    extends SimpleActionController {
        public RSSAction(String actionName, String windowId) {
            super(actionName, windowId, RssTemplateFactory.this);
        }

        @Override
        protected ResponseAction processSimpleAction() {
            RssTemplate rssTemplate = this.createRssTemplate();
            IMapSequence rootMap = MapSequence.fromMap(new HashMap());
            return ResponseFactory.getInstance().getXmlRenderResponseAction(rssTemplate, (Map<String, Object>)rootMap);
        }

        @Override
        public boolean requiresBasicAuth() {
            return false;
        }

        @Override
        protected String getBasicAuthRealm() {
            return "webr";
        }

        @Override
        void init() {
        }

        public abstract RssTemplate createRssTemplate();
    }
}

