/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateEventHandler {
    protected static Log log = LogFactory.getLog(TemplateEventHandler.class);
    private String eventName;
    private _FunctionTypes._void_P0_E0 handler;
    private _FunctionTypes._return_P0_E0<? extends Boolean> securityConstraint;

    public TemplateEventHandler(String eventName) {
        this.eventName = StringInterner.intern((String)eventName);
    }

    public TemplateEventHandler(String eventName, _FunctionTypes._void_P0_E0 handler) {
        this(eventName);
        this.handler = handler;
    }

    public TemplateEventHandler(String eventName, _FunctionTypes._void_P0_E0 handler, _FunctionTypes._return_P0_E0<? extends Boolean> securityConstraint) {
        this(eventName, handler);
        this.securityConstraint = securityConstraint;
    }

    public void handle() {
        if (this.securityConstraint != null && !((Boolean)this.securityConstraint.invoke()).booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No access rights for event [" + this.eventName + "]"));
            }
            throw new LocalizedSecurityException(new LocalizationObject("TemplateEventHandler.You_have_not_enough_permissions_to_perform_the_operation_Try_to_reload_the_page_and_check_if_you_are_logged_in_If_it_doesn_t_help_please_consult_with_your_server_s_administrator", new Object[0]));
        }
        if (this.handler != null) {
            this.handler.invoke();
        }
    }

    public String getEventName() {
        return this.eventName;
    }
}

