/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.webr.runtime.util.UserBrowser;
import jetbrains.mps.webr.runtime.util.UserOS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class UserAgentUtil {
    private static String[] IGNORE = new String[]{"googlebot", "msnbot", "webcrawler", "help.yahoo.com", "commons-httpclient", "about.ask.com", "yandex", "thunderbird", "www.cuil.com", "www.youdao.com", "apple-pubsub/65", "Mozilla/0.6 Beta (Windows)".toLowerCase(), "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)".toLowerCase(), "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)".toLowerCase(), "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1.4322)".toLowerCase()};
    private static Pattern MOBILE_USER_AGENT = Pattern.compile(".*(android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\\/|plucker|pocket|psp|symbian|treo|up\\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino).*");
    protected static Log log = LogFactory.getLog(UserAgentUtil.class);

    public static String getKnownBrowserShortName() {
        String browserName = UserAgentUtil._getBrowserName(UserAgentUtil.getUserAgent(), false);
        if (browserName == null || UserAgentUtil.eq_8s4n7i_a0a2a0(browserName, "unknown")) {
            browserName = null;
        }
        return browserName;
    }

    public static UserBrowser getUserBrowser() {
        UserBrowser browser;
        block3: {
            browser = UserBrowser.UNKNOWN;
            try {
                String userAgent = UserAgentUtil.getUserAgent();
                for (UserBrowser b : UserBrowser.values()) {
                    if (userAgent.indexOf(b.shortName) == -1) continue;
                    browser = b;
                    break;
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"User agent probably not defined!", (Throwable)e);
            }
        }
        return browser;
    }

    public static String getKnownBrowserVersion() {
        String agent = UserAgentUtil.getUserAgent();
        String name = UserAgentUtil.getKnownBrowserShortName();
        if (name == null || agent.equals(name)) {
            return null;
        }
        return UserAgentUtil._getMajorVersion(agent, agent.indexOf(name) + name.length() + 1);
    }

    public static boolean isMobileBrowser() {
        return UserAgentUtil.isMobileBrowser(UserAgentUtil.getUserAgent());
    }

    public static boolean isMobileBrowser(String userAgent) {
        return MOBILE_USER_AGENT.matcher(userAgent).matches();
    }

    public static boolean isChromeFrame() {
        return UserAgentUtil.getUserAgent().indexOf("chromeframe") != -1;
    }

    public static UserOS getUserOS() {
        UserOS os;
        block4: {
            os = UserOS.UNKNOWN;
            try {
                String userAgent = UserAgentUtil.getUserAgent();
                for (UserOS userOS : UserOS.values()) {
                    for (String o : userOS.possibleNames) {
                        if (userAgent.indexOf(o) == -1) continue;
                        os = userOS;
                        break block4;
                    }
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"User agent probably not defined!", (Throwable)e);
            }
        }
        return os;
    }

    private static String getUserAgent() {
        HttpServletRequest request = BaseApplication.getRequest();
        if (request == null) {
            return "";
        }
        String header = request.getHeader("User-Agent");
        return header == null || header.length() == 0 ? "" : header.toLowerCase();
    }

    private static String _getBrowserName(String userAgent, boolean withVersion) {
        block4: {
            try {
                int pos;
                for (String string : IGNORE) {
                    pos = userAgent.indexOf(string);
                    if (pos == -1) continue;
                    return null;
                }
                for (UserBrowser userBrowser : UserBrowser.values()) {
                    pos = userAgent.indexOf(userBrowser.shortName);
                    if (pos == -1) continue;
                    return userBrowser.shortName + (withVersion ? " " + UserAgentUtil._getMajorVersion(userAgent, pos + userBrowser.shortName.length() + 1) : "");
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)("Can't recognize userAgent [" + userAgent + "]"), (Throwable)e);
            }
        }
        return UserBrowser.UNKNOWN.shortName;
    }

    private static String _getMajorVersion(String userAgent, int pos) {
        int space = userAgent.indexOf(" ", pos);
        space = space == -1 ? userAgent.length() : space;
        int dot = userAgent.indexOf(".", pos);
        dot = dot == -1 ? userAgent.length() : dot;
        return userAgent.substring(pos, Math.min(space, dot));
    }

    private static String _getUserOSName(String userAgent, boolean withVersion) {
        block5: {
            try {
                int pos;
                String _userAgent = userAgent.toLowerCase();
                for (String string : IGNORE) {
                    pos = _userAgent.indexOf(string);
                    if (pos == -1) continue;
                    return null;
                }
                for (UserOS userOS : UserOS.values()) {
                    for (String os : userOS.possibleNames) {
                        pos = _userAgent.indexOf(os);
                        if (pos == -1) continue;
                        return userOS.name + (withVersion ? " " + UserAgentUtil._getOSVersion(userAgent, os, pos + os.length() + 1) : "");
                    }
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)("Can't recognize user OS in userAgent [" + userAgent + "]"), (Throwable)e);
            }
        }
        return UserOS.UNKNOWN.name;
    }

    private static String _getOSVersion(String userAgent, String osMatch, int position) {
        int pos = position;
        while (pos >= 0) {
            pos = userAgent.indexOf(osMatch);
        }
        return "";
    }

    public static String getBrowserSpecificCssClass() {
        String css = UserAgentUtil.getKnownBrowserShortName();
        if (css != null) {
            String browserVersion;
            if (css.indexOf(UserBrowser.INTERNET_EXPLORER.shortName) != -1 && (browserVersion = UserAgentUtil.getKnownBrowserVersion()) != null) {
                css = css + browserVersion;
            }
            return css;
        }
        return "";
    }

    private static boolean eq_8s4n7i_a0a2a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

