/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.component.table;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import webr.framework.controller.BaseApplication;

public class TableViewModel {
    private static final SortState NO_COLUMN = new SortState(-1, true);
    public static final int UNDEFINED_SORT_ORDER = -1;
    private List<SortState> mySortStates = new ArrayList<SortState>();
    private int myCurrentPage = 1;
    private int myPageSize = 10;
    private int myRowsCount = 0;

    public int getSortColumn() {
        return this.getSortColumn(0);
    }

    public boolean isSortAsc() {
        return this.isSortAsc(0);
    }

    public void setSortColumn(int sortColumn) {
        this.setFirstSortColumn(sortColumn, true);
    }

    public int getSortColumn(int order) {
        return this.getSortState((int)order).mySortColumn;
    }

    public boolean isSortAsc(int column) {
        boolean sortAsc = true;
        int order = this.getSortOrder(column);
        if (order != -1) {
            sortAsc = this.getSortState((int)order).mySortAsc;
        }
        return sortAsc;
    }

    public int getSortOrder(int column) {
        int order = -1;
        for (int i = 0; i < this.mySortStates.size(); ++i) {
            if (this.mySortStates.get((int)i).mySortColumn != column) continue;
            order = i;
            break;
        }
        return order;
    }

    public boolean isSortInited() {
        return !this.mySortStates.isEmpty();
    }

    public int countSortColumns() {
        return this.mySortStates.size();
    }

    private SortState getSortState(int order) {
        SortState sortState = NO_COLUMN;
        if (0 <= order && order < this.mySortStates.size()) {
            sortState = this.mySortStates.get(order);
        }
        return sortState;
    }

    public void setFirstSortColumn(int sortColumn, boolean defaultSortAsc) {
        SortState sortState;
        int currentOrder = this.getSortOrder(sortColumn);
        if (currentOrder != -1) {
            sortState = this.getSortState(currentOrder);
            sortState.toggleSortDirection(currentOrder == 0);
        } else {
            sortState = new SortState(sortColumn, defaultSortAsc);
        }
        this.mySortStates.clear();
        this.mySortStates.add(sortState);
    }

    public void appendSortColumn(int sortColumn, boolean defaultSortAsc) {
        SortState sortState;
        int currentOrder = this.getSortOrder(sortColumn);
        if (currentOrder != -1) {
            sortState = this.mySortStates.get(currentOrder);
            sortState.toggleSortDirection(currentOrder == this.mySortStates.size() - 1);
            this.mySortStates.remove(sortState);
        } else {
            sortState = new SortState(sortColumn, defaultSortAsc);
        }
        this.mySortStates.add(sortState);
    }

    public void prependSortColumn(int sortColumn, boolean defaultSortAsc) {
        SortState sortState;
        int currentOrder = this.getSortOrder(sortColumn);
        if (currentOrder != -1) {
            sortState = this.mySortStates.get(currentOrder);
            sortState.toggleSortDirection(currentOrder == 0);
            this.mySortStates.remove(sortState);
        } else {
            sortState = new SortState(sortColumn, defaultSortAsc);
        }
        this.mySortStates.add(0, sortState);
    }

    public int getCurrentPage() {
        return this.myCurrentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.myCurrentPage = Math.max(1, currentPage);
    }

    public int getPageSize() {
        return this.myPageSize;
    }

    public void setPageSize(int pageSize) {
        this.myPageSize = Math.max(1, pageSize);
    }

    public int getRowsCount() {
        return this.myRowsCount;
    }

    public void setRowsCount(int rowsCount) {
        this.myRowsCount = Math.max(0, rowsCount);
        this.myCurrentPage = Math.min(this.myCurrentPage, this.countPages());
    }

    public int countPages() {
        return Math.max(1, this.myRowsCount / this.myPageSize + (this.myRowsCount % this.myPageSize > 0 ? 1 : 0));
    }

    public int getFromRow() {
        return Math.max((this.myCurrentPage - 1) * this.myPageSize, 0);
    }

    public int getToRow() {
        return Math.min(this.myCurrentPage * this.myPageSize, this.myRowsCount);
    }

    public static TableViewModel get(String tableViewModelName) {
        HttpSession session = BaseApplication.getRequest().getSession();
        TableViewModel tableViewModel = (TableViewModel)session.getAttribute(tableViewModelName);
        if (tableViewModel == null) {
            tableViewModel = new TableViewModel();
            session.setAttribute(tableViewModelName, (Object)tableViewModel);
        }
        return tableViewModel;
    }

    private static class SortState {
        public int mySortColumn;
        public boolean mySortAsc;

        public SortState(int sortColumn, boolean sortAsc) {
            this.mySortColumn = sortColumn;
            this.mySortAsc = sortAsc;
        }

        public void toggleSortDirection(boolean toggelCondition) {
            if (toggelCondition) {
                this.mySortAsc = !this.mySortAsc;
            }
        }
    }
}

