/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class BeanContainer {
    private static final Log log = LogFactory.getLog(BeanContainer.class);
    private final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();
    private final ServletContext context;
    protected final Object writeSynchObject = new Object();
    protected volatile boolean destroying = false;
    private volatile Map<String, Object> beans = new HashMap();

    public BeanContainer(ServletContext context) {
        this.context = context;
    }

    public Object getBean(@NotNull String name) {
        return this.beans.get(name);
    }

    public int getBeanCount() {
        return this.beans.size();
    }

    public ServletContext getContext() {
        return this.context;
    }

    void setBean(@NotNull String name, @NotNull Object bean) {
        Map<String, Object> beans = this.beans;
        HashMap result = new HashMap(beans.size() + 1);
        for (String existing : beans.keySet()) {
            result.put(existing, beans.get(existing));
        }
        result.put(name, bean);
        this.beans = result;
    }

    Object remove(@NotNull String removed) {
        Map<String, Object> beans = this.beans;
        HashMap result = new HashMap(beans.size() - 1);
        for (String name : beans.keySet()) {
            if (removed.equals(name)) continue;
            result.put(name, beans.get(name));
        }
        this.beans = result;
        return beans.get(removed);
    }

    void registerDestructionCallback(String name, Runnable callback) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register destructor callback for bean " + name));
        }
        this.destructionCallbacks.put(name, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(ConfigurableBeanFactory factory) {
        LinkedHashMap<String, Runnable> callbacks = new LinkedHashMap<String, Runnable>();
        Object object = this.writeSynchObject;
        synchronized (object) {
            if (this.destroying) {
                throw new IllegalStateException("Container is already being destroyed!");
            }
            this.destroying = true;
            for (String beanName : this.destructionCallbacks.keySet()) {
                callbacks.put(beanName, this.destructionCallbacks.get(beanName));
            }
        }
        HashSet<String> visitedBeans = new HashSet<String>();
        ArrayList list = new ArrayList(callbacks.size());
        list.addAll(callbacks.keySet());
        for (int i = list.size() - 1; i >= 0; --i) {
            String beanName = (String)list.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling destructor callback for bean: " + beanName));
            }
            BeanContainer.closeBean(factory, beanName, visitedBeans, callbacks);
        }
    }

    public boolean isDestroying() {
        return this.destroying;
    }

    private static void closeBean(ConfigurableBeanFactory factory, String beanName, Set<String> visited, Map<String, Runnable> callbacks) {
        Runnable callback;
        if (visited.contains(beanName)) {
            return;
        }
        visited.add(beanName);
        for (String dependentBean : factory.getDependentBeans(beanName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing dependent bean - " + dependentBean));
            }
            BeanContainer.closeBean(factory, dependentBean, visited, callbacks);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing bean - " + beanName));
        }
        if ((callback = callbacks.get(beanName)) != null) {
            callback.run();
        }
    }
}

