/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.util.LinkedList;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.ContainerHolder;
import webr.framework.controller.MultipleContainerHolder;
import webr.framework.controller.SingleContainerHolder;

public class WebLocalScope
implements Scope {
    private static final Log log = LogFactory.getLog(WebLocalScope.class);
    public static final String MDC_SERVLET_CONTEXT_KEY = WebLocalScope.class.getName() + "ServletContext";
    public static final String MDC_DOMAIN_KEY = "domain";
    public static final ThreadLocal<BeanContainer> LOCAL_CONTAINER = new ThreadLocal();
    public static final ContainerHolder CONTAINER_HOLDER = WebLocalScope.newContainerHolder();

    public Object resolveContextualObject(String s) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        BeanContainer container = WebLocalScope.getContainer();
        Object result = container.getBean(name);
        if (result != null) {
            return result;
        }
        if (container.destroying) {
            throw new IllegalStateException("Container already closed");
        }
        Object object = container.writeSynchObject;
        synchronized (object) {
            result = container.getBean(name);
            if (result != null) {
                return result;
            }
            result = objectFactory.getObject();
            if (result != null) {
                container.setBean(name, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        BeanContainer container = WebLocalScope.getContainer();
        Object object = container.writeSynchObject;
        synchronized (object) {
            return container.remove(name);
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        WebLocalScope.getContainer().registerDestructionCallback(name, callback);
    }

    public String getConversationId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(ConfigurableBeanFactory factory) {
        BeanContainer container = WebLocalScope.getNullableContainer();
        if (container == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No BeanContainer found, maybe WebLocalScope not yet initialized");
            }
            return;
        }
        try {
            container.destroy(factory);
        }
        finally {
            CONTAINER_HOLDER.remove(container);
            LOCAL_CONTAINER.remove();
        }
    }

    static void closeAll(ConfigurableBeanFactory factory) {
        LinkedList<BeanContainer> containers = new LinkedList<BeanContainer>(CONTAINER_HOLDER.values());
        for (BeanContainer container : containers) {
            container.destroy(factory);
        }
        CONTAINER_HOLDER.clear();
    }

    public static boolean isEmpty() {
        return CONTAINER_HOLDER.isEmpty();
    }

    @Nullable
    public static BeanContainer getContainerDontCreate() {
        ServletContext context = BaseApplication.getServletContext();
        if (context == null) {
            return LOCAL_CONTAINER.get();
        }
        return CONTAINER_HOLDER.get(context);
    }

    @Nullable
    public static BeanContainer getNullableContainer() {
        ServletContext context = BaseApplication.getServletContext();
        if (context == null) {
            BeanContainer container = LOCAL_CONTAINER.get();
            if (container == null) {
                return null;
            }
            return container;
        }
        BeanContainer container = CONTAINER_HOLDER.get(context);
        if (container == null) {
            container = CONTAINER_HOLDER.putIfAbsent(context, new BeanContainer(context));
        }
        return container;
    }

    @NotNull
    public static BeanContainer getContainer() {
        BeanContainer result = WebLocalScope.getNullableContainer();
        if (result == null) {
            return WebLocalScope.fail();
        }
        return result;
    }

    static BeanContainer fail() {
        throw new IllegalStateException("No local bean container provided!");
    }

    @NotNull
    public static BeanContainer getContainer(ServletContext context) {
        BeanContainer result = CONTAINER_HOLDER.get(context);
        if (result == null) {
            WebLocalScope.fail();
        }
        return result;
    }

    public static void setLocalBeanContainer(BeanContainer beanContainer) {
        LOCAL_CONTAINER.set(beanContainer);
        MDC.put((String)MDC_SERVLET_CONTEXT_KEY, (Object)beanContainer.getContext());
        String domain = beanContainer.getContext().getInitParameter(MDC_DOMAIN_KEY);
        if (domain != null) {
            MDC.put((String)MDC_DOMAIN_KEY, (Object)domain);
        }
    }

    public static void removeLocalBeanContainer() {
        LOCAL_CONTAINER.remove();
        MDC.remove((String)MDC_SERVLET_CONTEXT_KEY);
        MDC.remove((String)MDC_DOMAIN_KEY);
    }

    public static ContainerHolder newContainerHolder() {
        if (Boolean.getBoolean("jetbrains.webr.singleTierApp")) {
            return new SingleContainerHolder();
        }
        return new MultipleContainerHolder();
    }
}

