/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.runtime.response;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.webr.runtime.cache.CacheControlUtil;
import jetbrains.mps.webr.runtime.requestProcessor.MimeType;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.WebrBuffer;
import webr.framework.textBuilder.WebrBuilderContext;

public abstract class JsCommandResponse
implements ResponseAction {
    private CharSequence myContentString = null;
    private TemplateComponent myTemplateComponent = null;

    protected JsCommandResponse() {
    }

    public void setTemplateComponent(TemplateComponent templateComponent) {
        this.myTemplateComponent = templateComponent;
    }

    @Override
    public void doAction(HttpServletResponse response) throws IOException {
        this.generateContent();
        response.setContentType(MimeType.TEXT_XML.getPresentation());
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        CacheControlUtil.setNonCacheableHeaders(response);
        if (WebrBuffer.USE_CHAR_SEQUENCE) {
            WebrBuilderContext.writeCharSequence(this.myContentString, response.getWriter());
        } else {
            byte[] bytes = this.generateBinaryContent();
            response.getOutputStream().write(bytes);
        }
    }

    public void prebuildContent() {
        this.generateContent();
    }

    boolean contentNotGenerated() {
        return this.myContentString == null;
    }

    void doGenerateScript(TBuilderContext builderContext) {
        if (this.contentNotGenerated()) {
            builderContext.pushCurrentTemplateComponent(this.myTemplateComponent);
            this.generateScript(builderContext);
        } else {
            builderContext.append(this.myContentString);
        }
    }

    private void generateContent() {
        if (this.contentNotGenerated()) {
            TBuilderContext builderContext = new TBuilderContext();
            builderContext.setSkipScriptIncludes(true);
            builderContext.setWindowId(BaseApplication.getCurrentWindowId());
            this.doGenerateScript(builderContext);
            this.myContentString = WebrBuffer.USE_CHAR_SEQUENCE ? builderContext.getCharSequence() : builderContext.getText();
        }
    }

    private byte[] generateBinaryContent() {
        this.generateContent();
        return ((String)this.myContentString).getBytes(StandardCharsets.UTF_8);
    }

    protected abstract void generateScript(TBuilderContext var1);

    public boolean isRequiresRebuildTemplateParameters() {
        return false;
    }
}

