/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.textBuilder;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletResponse;
import jetbrains.exodus.core.dataStructures.decorators.HashMapDecorator;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.gtext.runtime.TContent;
import jetbrains.mps.webr.runtime.debug.DebugFileUtil;
import jetbrains.mps.webr.runtime.templateComponent.LayoutComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.util.ParameterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.function.HtmlStringUtil;

public abstract class WebrBuilderContext
extends TBaseBuilderContext {
    protected static final Log log = LogFactory.getLog(WebrBuilderContext.class);
    protected String myCurrentTemplateName;
    protected String myCurrentLayoutName;
    protected String myTemplateStylesheetPath;
    protected TemplateComponent myCurrentTemplateComponent;
    protected String myWindowId;
    protected LinkedList<Map<String, TemplateComponent>> myOldChildrenTemplateComponentsStack;
    protected boolean mySkipScriptIncludes = false;
    protected Map<String, String> myIds = new HashMapDecorator();
    protected PrintWriter out;
    protected Set<String> dynamicallyIncludedTemplates = new HashSetDecorator();
    private static String TMP_PLACEHOLDER = "__TMP_PLACEHOLDER__";
    private int tmp = 0;

    public void start(ServletResponse response) {
        try {
            this.out = response.getWriter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void flushInternal() throws IOException {
        if (this.out.checkError()) {
            throw new IOException("Error during flush.");
        }
    }

    public void end() {
    }

    public TemplateComponent getCurrentTemplateComponent() {
        return this.myCurrentTemplateComponent;
    }

    public void pushCurrentTemplateComponent(TemplateComponent currentTemplateComponent) {
        this.myCurrentTemplateComponent = currentTemplateComponent;
    }

    public TemplateComponent popCurrentTemplateComponent() {
        TemplateComponent oldTemplateComponent = this.myCurrentTemplateComponent;
        if (this.myCurrentTemplateComponent != null) {
            this.myCurrentTemplateComponent = this.myCurrentTemplateComponent.getParentTemplateComponent();
        }
        return oldTemplateComponent;
    }

    public String getCurrentTemplateName() {
        return this.myCurrentTemplateName;
    }

    public void setCurrentTemplateName(String currentTemplateName) {
        this.myCurrentTemplateName = currentTemplateName;
    }

    public String getCurrentLayoutName() {
        return this.myCurrentLayoutName;
    }

    public void setCurrentLayoutName(String currentLayoutName) {
        this.myCurrentLayoutName = currentLayoutName;
    }

    public void pushOldChildrenTemplateComponents(Map<String, TemplateComponent> oldChildrenTemplateComponents) {
        if (this.myOldChildrenTemplateComponentsStack == null) {
            this.myOldChildrenTemplateComponentsStack = new LinkedList();
        }
        this.myOldChildrenTemplateComponentsStack.addLast(oldChildrenTemplateComponents);
    }

    public Map<String, TemplateComponent> popOldChildrenTemplateComponents() {
        Map<String, TemplateComponent> last = null;
        if (this.myOldChildrenTemplateComponentsStack != null) {
            last = this.myOldChildrenTemplateComponentsStack.removeLast();
        }
        return last;
    }

    public TemplateComponent getOldChildTemplateComponent(String templateComponentKey) {
        Map<String, TemplateComponent> map;
        TemplateComponent templateComponent = null;
        if (this.myOldChildrenTemplateComponentsStack != null && this.myOldChildrenTemplateComponentsStack.size() > 0 && (templateComponent = (map = this.myOldChildrenTemplateComponentsStack.getLast()).get(templateComponentKey)) != null) {
            map.remove(templateComponentKey);
        }
        return templateComponent;
    }

    public TemplateComponent getNonLayoutRootTemplateComponent() {
        TemplateComponent nestedTemplateComponent = null;
        if (this.myCurrentTemplateComponent != null) {
            TemplateComponent rootTemplateComponent = this.myCurrentTemplateComponent.getRootTemplateComponent();
            nestedTemplateComponent = rootTemplateComponent instanceof LayoutComponent ? rootTemplateComponent.getNestedTemplateComponent() : rootTemplateComponent;
        }
        return nestedTemplateComponent;
    }

    public void setTemplateStylesheetPath(String templateStylesheetPath) {
        this.myTemplateStylesheetPath = templateStylesheetPath;
    }

    public boolean hasTemplateStylesheet() {
        return this.myTemplateStylesheetPath != null;
    }

    public String getTemplateStylesheetPath() {
        return this.myTemplateStylesheetPath;
    }

    public boolean isSkipScriptIncludes() {
        return this.mySkipScriptIncludes;
    }

    public void setSkipScriptIncludes(boolean skipScriptIncludes) {
        this.mySkipScriptIncludes = skipScriptIncludes;
    }

    public String getWindowId() {
        return this.myWindowId;
    }

    public void setWindowId(String windowId) {
        this.myWindowId = windowId;
    }

    public void saveBuffer() {
        this.startContentBlock(TMP_PLACEHOLDER + this.tmp++);
    }

    public void restoreBuffer(HtmlStringUtil.EscapeKind escapeKind) {
        String escapedText;
        TContent content = (TContent)this.getContentsStack().peek();
        String text = content.getBuf().getText();
        switch (escapeKind) {
            case ESCAPE_HTML: {
                escapedText = HtmlStringUtil.html(text);
                break;
            }
            case ESCAPE_STRING_LITERAL: {
                escapedText = HtmlStringUtil.stringLiteral((Object)text);
                break;
            }
            case SINGLE_LINE: {
                escapedText = HtmlStringUtil.singleLine(text);
                break;
            }
            case DOUBLE_TO_SINGLE_QUOTES: {
                escapedText = HtmlStringUtil.doubleToSingleQuotes(text);
                break;
            }
            case SINGLE_LINE_AND_DOUBLE_TO_SINGLE_QUOTES: {
                escapedText = HtmlStringUtil.singleLineAnddoubleToSingleQuotes(text);
                break;
            }
            default: {
                escapedText = text;
            }
        }
        this.endContentBlock();
        this.getContents().remove(content.getName());
        this.append(escapedText);
    }

    public String checkId(String id, Object ... parameters) {
        String templateName;
        String resultId = parameters.length > 0 ? ParameterUtil.getParameterString(id, parameters) : id;
        TemplateComponent templateComponent = this.getCurrentTemplateComponent();
        String string = templateName = templateComponent != null ? templateComponent.getTemplateName() : "<unknown template>";
        if (this.myIds.containsKey(resultId)) {
            String message = "duplicate ids: \"" + resultId + "\" in templates [" + this.myIds.get(resultId) + "] and [" + templateName + "]";
            if (DebugFileUtil.isDebug()) {
                throw new RuntimeException(message);
            }
            log.error((Object)message);
        } else {
            this.myIds.put(resultId, templateName);
        }
        return resultId;
    }

    public Writer getWriter() {
        return this.out;
    }

    public boolean addDynamicallyIncludedTemplate(String name) {
        return this.dynamicallyIncludedTemplates.add(name);
    }

    public static void writeCharSequence(@NotNull CharSequence s, @NotNull PrintWriter writer) {
        char[] buffer = new char[256];
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (j == buffer.length) {
                writer.write(buffer);
                j = 0;
            }
            buffer[j++] = s.charAt(i);
        }
        if (j > 0) {
            writer.write(buffer, 0, j);
        }
    }
}

