/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.youtrack.api.commands.CommandQuickFix;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.parser.api.IPrefixTreesData;
import jetbrains.youtrack.parser.api.IWord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCell
implements ICell {
    protected static Log log = LogFactory.getLog(AbstractCell.class);
    ICommand command;

    public void setCommand(ICommand command) {
        this.command = command;
    }

    public ICommand getCommand() {
        return this.command;
    }

    IPrefixTreesData getPrefixTrees() {
        return this.command.getCommandList().getPrefixTrees();
    }

    IContext getContext() {
        return this.command.getCommandList().getContext();
    }

    List<IWord> getTokens() {
        if (this.command != null) {
            if (this.command.getCommandList() != null) {
                return this.command.getCommandList().getTokens();
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)new IllegalStateException("No command list found in command (JT-38213): " + this.command.getDebugDescription()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)new IllegalStateException("No command is defined for a cell (JT-38213): " + this.getClass() + " " + this.getText()));
        }
        return Collections.emptyList();
    }

    public int getType() {
        return this.isError() ? 3 : 2;
    }

    public String getText() {
        return "";
    }

    public boolean isError() {
        return false;
    }

    public Collection<CommandQuickFix> getQuickFix() {
        return Collections.EMPTY_LIST;
    }
}

