/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldNode;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.LocalContext;
import jetbrains.youtrack.api.parser.Suggestable;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.commands.impl.AbstractCell;
import jetbrains.youtrack.commands.impl.CommandPrefixTreeKey;
import jetbrains.youtrack.commands.impl.CommandType;
import jetbrains.youtrack.commands.impl.StringUtils;
import jetbrains.youtrack.commands.impl.SuggestFieldPredicate;
import jetbrains.youtrack.commands.impl.SuggestFieldValuePredicate;
import jetbrains.youtrack.parser.api.CharIterable;
import jetbrains.youtrack.parser.api.CharIterableFactory;
import jetbrains.youtrack.parser.api.IPredicate;
import jetbrains.youtrack.parser.api.IWord;
import jetbrains.youtrack.parser.api.PrefixIterable;
import jetbrains.youtrack.parser.api.PrefixIterator;
import jetbrains.youtrack.parser.api.WordStringUtil;
import jetbrains.youtrack.parser.base.SuggestItem;
import jetbrains.youtrack.parser.prefixTree.OrPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTokensCell
extends AbstractCell {
    static final int LOOK_BACK_SUGGEST_CELLS = 3;
    static AcceptCommandTypePredicate COMMAND_TYPE_PREDICATE = new AcceptCommandTypePredicate();
    static AcceptLinkTypePredicate LINK_TYPE_PREDICATE = new AcceptLinkTypePredicate();
    private static final Iterable<String> COMMAND_TREE_KEYS = Sequence.singleton((Object)CommandPrefixTreeKey.COMMANDS_TREE_KEY);
    private static final Iterable<String> CATEGORY_TREE_KEYS = Sequence.singleton((Object)"CATEGORY");
    int startToken;
    int stopToken;
    CommandType commandType;
    IField field;
    IField addForField;
    CommandType addForCommandType;

    AbstractTokensCell(int startToken, int stopToken, @Nullable CommandType type2, @Nullable IField field) {
        this(startToken, stopToken, type2, field, null, null);
    }

    AbstractTokensCell(int startToken, int stopToken, @Nullable CommandType type2, @Nullable IField field, @Nullable CommandType addForCommandType, @Nullable IField addForField) {
        this.startToken = startToken;
        this.stopToken = stopToken;
        this.commandType = type2;
        this.field = field;
        this.addForCommandType = addForCommandType;
        this.addForField = addForField;
    }

    public int getStart() {
        return this.startToken >= ListSequence.fromList(this.getTokens()).count() ? 0 : ((IWord)ListSequence.fromList(this.getTokens()).getElement(this.startToken)).getStartOffset();
    }

    public int getStartToken() {
        return this.startToken;
    }

    public int getEnd() {
        return this.stopToken >= ListSequence.fromList(this.getTokens()).count() ? 0 : ((IWord)ListSequence.fromList(this.getTokens()).getElement(this.stopToken)).getEndOffset();
    }

    public boolean containsPos(int pos) {
        return this.findWord(pos) != null;
    }

    int getStopOffset(int pos) {
        IWord word = this.findWord(pos);
        return word == null ? 0 : pos - word.getStartOffset();
    }

    IWord findWord(int pos) {
        List<IWord> tokens = this.getTokens();
        if (ListSequence.fromList(tokens).isEmpty()) {
            return null;
        }
        for (int i = Math.min(ListSequence.fromList(tokens).count() - 1, this.startToken); i <= Math.min(ListSequence.fromList(tokens).count() - 1, this.stopToken); ++i) {
            IWord word = (IWord)ListSequence.fromList(tokens).getElement(i);
            if (word.getStartOffset() > pos || pos > word.getEndOffset()) continue;
            return word;
        }
        return null;
    }

    protected int getMatch(int pos) {
        return this.getMatch(this.startToken, pos);
    }

    protected int getMatch(int startToken, int pos) {
        return startToken >= ListSequence.fromList(this.getTokens()).count() ? 0 : pos - ((IWord)ListSequence.fromList(this.getTokens()).getElement(startToken)).getStartOffset();
    }

    protected int getStartOffset(int pos) {
        return this.getStartOffset(this.startToken, pos);
    }

    protected int getStartOffset(int startToken, int pos) {
        return startToken >= ListSequence.fromList(this.getTokens()).count() ? pos : ((IWord)ListSequence.fromList(this.getTokens()).getElement(startToken)).getStartOffset();
    }

    protected int getEndOffset(int pos) {
        return this.stopToken >= ListSequence.fromList(this.getTokens()).count() ? pos : ((IWord)ListSequence.fromList(this.getTokens()).getElement(this.stopToken)).getEndOffset();
    }

    protected String getCellText() {
        return ((WordStringUtil)ServiceLocator.getBean((String)"wordStringUtil")).toString(this.getTokens(), this.startToken, this.stopToken);
    }

    @Override
    public String getText() {
        return ((WordStringUtil)ServiceLocator.getBean((String)"wordStringUtil")).toString(this.getTokens(), this.startToken, this.stopToken);
    }

    @NotNull
    protected String getText(int startToken, int pos) {
        List<IWord> tokens = this.getTokens();
        if (startToken >= ListSequence.fromList(tokens).count()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = startToken; i <= Math.min(ListSequence.fromList(tokens).count() - 1, this.stopToken); ++i) {
            IWord token = (IWord)ListSequence.fromList(this.getTokens()).getElement(i);
            if (token.getEndOffset() < pos) {
                builder.append(token.getWord());
                continue;
            }
            if (token.getStartOffset() >= pos) break;
            builder.append(StringUtils.substring(token.getWord(), 0, pos - token.getStartOffset()));
        }
        return builder.toString();
    }

    public Iterable<SuggestItem> getSuggestions(int pos) {
        SuggestCollector collector = new SuggestCollector();
        this.addLoopBackSuggestions(collector, pos);
        this.addThisCellSuggestions(collector, pos);
        return collector.getSuggestItems();
    }

    SuggestCollector addThisCellSuggestions(SuggestCollector collector, int pos) {
        if (this.field != null) {
            return this.addFieldValuesSuggestions(this.commandType, this.field, collector, pos);
        }
        if (this.commandType != null && this.commandType.isPredefined() && (this.commandType.getPredefinedCommandType() == PredefinedCommandType.add || this.commandType.getPredefinedCommandType() == PredefinedCommandType.remove)) {
            return this.addLinkTypesAndFieldsAndFieldValuesSuggestions(this.commandType, collector, pos);
        }
        return this.addAllSuggestions(collector, pos);
    }

    SuggestCollector addAllSuggestions(SuggestCollector collector, int pos) {
        if (this.addForField != null) {
            this.addFieldValuesSuggestions(this.addForCommandType, this.addForField, collector, pos);
        }
        ISequence treeKeys = Sequence.fromIterable(COMMAND_TREE_KEYS).concat(Sequence.fromIterable(CATEGORY_TREE_KEYS).concat(Sequence.fromIterable((Iterable)this.getPrefixTrees().getFilterTreeKeys())));
        OrPredicate predicate = new OrPredicate(new IPredicate[]{new SuggestFieldPredicate(this.getContext(), null), new SuggestFieldValuePredicate(this.getContext(), null, null, this.getCommand().getCommandList()), COMMAND_TYPE_PREDICATE});
        int thisCellIndex = this.command.getCommandList().getCellIndex((ICell)this);
        return this.addSuggestions(collector, pos, (Iterable<String>)treeKeys, (IPredicate)predicate, thisCellIndex, thisCellIndex);
    }

    SuggestCollector addLinkTypesAndFieldsAndFieldValuesSuggestions(@NotNull CommandType commandType, SuggestCollector collector, int pos) {
        this.addLinkTypesSuggestions(commandType, collector, pos);
        this.addFieldsSuggestions(commandType, collector, pos);
        this.addFieldValuesSuggestions(commandType, null, collector, pos);
        return collector;
    }

    SuggestCollector addLinkTypesSuggestions(@NotNull CommandType commandType, @Nullable SuggestCollector collector, int pos) {
        Iterable<String> treeKeys = COMMAND_TREE_KEYS;
        int thisCellIndex = this.command.getCommandList().getCellIndex((ICell)this);
        return this.addSuggestions(collector, pos, treeKeys, LINK_TYPE_PREDICATE, thisCellIndex, thisCellIndex);
    }

    SuggestCollector addFieldsSuggestions(@Nullable CommandType commandType, @NotNull SuggestCollector collector, int pos) {
        SuggestFieldPredicate predicate = new SuggestFieldPredicate(this.getContext(), commandType == null ? null : commandType.getPredefinedCommandType());
        int thisCellIndex = this.command.getCommandList().getCellIndex((ICell)this);
        return this.addSuggestions(collector, pos, CATEGORY_TREE_KEYS, (IPredicate)predicate, thisCellIndex, thisCellIndex);
    }

    SuggestCollector addFieldValuesSuggestions(@Nullable CommandType commandType, @Nullable IField field, SuggestCollector collector, int pos) {
        int thisCellIndex = this.command.getCommandList().getCellIndex((ICell)this);
        return this.addSuggestions(collector, pos, field == null ? this.getPrefixTrees().getFilterTreeKeys() : field.getCommandTreeKeys(), (IPredicate)new SuggestFieldValuePredicate(this.getContext(), commandType == null ? null : commandType.getPredefinedCommandType(), field, this.getCommand().getCommandList()), thisCellIndex, thisCellIndex);
    }

    SuggestCollector addLoopBackSuggestions(SuggestCollector collector, int pos) {
        ISequence treeKeys = Sequence.fromIterable(COMMAND_TREE_KEYS).concat(Sequence.fromIterable(CATEGORY_TREE_KEYS).concat(Sequence.fromIterable((Iterable)this.getPrefixTrees().getFilterTreeKeys())));
        OrPredicate predicate = new OrPredicate(new IPredicate[]{new SuggestFieldPredicate(this.getContext(), null), new SuggestFieldValuePredicate(this.getContext(), null, null, this.getCommand().getCommandList()), COMMAND_TYPE_PREDICATE});
        int thisCellIndex = this.command.getCommandList().getCellIndex((ICell)this);
        return this.addSuggestions(collector, pos, (Iterable<String>)treeKeys, (IPredicate)predicate, Math.max(0, thisCellIndex - 3), thisCellIndex - 1);
    }

    SuggestCollector addSuggestions(SuggestCollector collector, int pos, Iterable<String> treeKeys, IPredicate predicate, int firstCell, int lastCell) {
        if (!collector.canAdd()) {
            return collector;
        }
        int completionEndOffset = this.getEndOffset(pos);
        int stopOffset = this.getStopOffset(pos);
        for (String treeKey : treeKeys) {
            for (int cellIndex = firstCell; cellIndex <= lastCell; ++cellIndex) {
                PrefixIterable iterable = this.getPrefixTrees().getTree(treeKey);
                PrefixIterator iterator = iterable.prefixIterator();
                ICell cellAtIndex = this.command.getCommandList().getCell(cellIndex);
                int completionStartOffset = cellAtIndex.getStart();
                int startToken = cellAtIndex.getStartToken();
                if (startToken < ListSequence.fromList(this.getTokens()).count()) {
                    CharIterable wordSequence = ((CharIterableFactory)ServiceLocator.getBean((String)"charIterableFactory")).createWordsIterable(this.getTokens(), startToken, Math.min(ListSequence.fromList(this.getTokens()).count() - 1, this.stopToken), stopOffset);
                    iterator.move(wordSequence);
                }
                Iterator itr = this.getPrefixTrees().sortValues(treeKey, iterator.getDescendantValues(predicate));
                while (itr.hasNext()) {
                    Suggestable value = (Suggestable)itr.next();
                    if (collector.addSuggestable(value, this.getText(startToken, pos), completionStartOffset, completionEndOffset)) continue;
                    return collector;
                }
            }
        }
        return collector;
    }

    public static boolean isEmpty_pr57un_a0b0a0c0(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_pr57un_a0a0b0b0a0c0(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_pr57un_a0a0c0b0a0c0(String str) {
        return str != null && str.length() > 0;
    }

    static class AcceptLinkTypePredicate
    implements IPredicate {
        public boolean matches(Object value) {
            return value instanceof CommandType && ((CommandType)value).isLink();
        }
    }

    static class AcceptCommandTypePredicate
    implements IPredicate {
        public boolean matches(Object value) {
            return value instanceof CommandType;
        }
    }

    class SuggestCollector {
        private List<SuggestItem> vipItems = ListSequence.fromList(new ArrayList());
        private List<SuggestItem> otherItems = ListSequence.fromList(new ArrayList());
        private Set<Object> alreadyAdded = SetSequence.fromSet(new HashSet());
        private Set<String> alreadyAddedFieldAliases = SetSequence.fromSet(new HashSet());
        private int max = ((CommandService)ServiceLocator.getBean((String)"commandService")).getSuggestLimit();

        protected Iterable<SuggestItem> getSuggestItems() {
            Iterable<SuggestItem> suggestItems = this.getSuggestItemsRaw();
            if (Sequence.fromIterable(suggestItems).isNotEmpty()) {
                IMapSequence options = MapSequence.fromMap(new HashMap());
                for (SuggestItem item : Sequence.fromIterable(suggestItems)) {
                    String currentOption = item.getOption().toLowerCase();
                    Tuples._2 option = (Tuples._2)MapSequence.fromMap((Map)options).get((Object)currentOption);
                    if (option != null) {
                        this.addFieldName(item);
                        option._1((Object)true);
                        continue;
                    }
                    MapSequence.fromMap((Map)options).put((Object)currentOption, (Object)MultiTuple.from((Object)item, (Object)false));
                }
                for (String key : SetSequence.fromSet((Set)MapSequence.fromMap((Map)options).keySet())) {
                    Tuples._2 option = (Tuples._2)MapSequence.fromMap((Map)options).get((Object)key);
                    if (!((Boolean)option._1()).booleanValue()) continue;
                    this.addFieldName((SuggestItem)option._0());
                }
            }
            return Sequence.fromIterable(suggestItems).select((_FunctionTypes._return_P1_E0)new ISelector<SuggestItem, SuggestItem>(){

                public SuggestItem select(SuggestItem it) {
                    return SuggestCollector.this.setCaretPosition(it);
                }
            });
        }

        private SuggestItem addFieldName(SuggestItem item) {
            Suggestion s;
            String categoryName;
            if (item instanceof Suggestion && (categoryName = (s = (Suggestion)item).getCategoryName()) != null && categoryName.length() > 0) {
                int moveMatch = categoryName.length() + 1;
                s.setOption(categoryName + " " + s.getOption());
                s.setMatchingStart(s.getMatchingStart() + moveMatch);
                s.setMatchingEnd(s.getMatchingEnd() + moveMatch);
            }
            return item;
        }

        private SuggestItem setCaretPosition(SuggestItem item) {
            Suggestion suggestion;
            if (item instanceof Suggestion && AbstractTokensCell.isEmpty_pr57un_a0b0a0c0((suggestion = (Suggestion)item).getSuffix())) {
                suggestion.setSuffix(" ");
                int prefixLength = AbstractTokensCell.isNotEmpty_pr57un_a0a0b0b0a0c0(suggestion.getPrefix()) ? suggestion.getPrefix().length() : 0;
                int suffixLength = AbstractTokensCell.isNotEmpty_pr57un_a0a0c0b0a0c0(suggestion.getSuffix()) ? suggestion.getSuffix().length() : 0;
                suggestion.setCaretPosition(suggestion.getCompletionStart() + prefixLength + suggestion.getOption().length() + suffixLength);
            }
            return item;
        }

        private Iterable<SuggestItem> getSuggestItemsRaw() {
            return ListSequence.fromList(this.vipItems).concat((ISequence)ListSequence.fromList(this.otherItems));
        }

        public boolean canAdd() {
            return this.max > 0;
        }

        public boolean addSuggestable(Suggestable kp, String matchingText, int completionStart, int completionEnd) {
            Suggestion s;
            if (kp == null || this.isAdded(kp)) {
                return this.canAdd();
            }
            if (kp instanceof BaseFieldNode) {
                BaseFieldNode fieldNode = (BaseFieldNode)kp;
                String alias = fieldNode.getFieldAlias().getAlias();
                if (SetSequence.fromSet(this.alreadyAddedFieldAliases).contains((Object)alias)) {
                    return this.canAdd();
                }
                s = fieldNode.getSuggestion(matchingText, completionStart, completionEnd, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AbstractTokensCell.change_{0}", new Object[]{fieldNode.getField().getPresentation()}));
                SetSequence.fromSet(this.alreadyAddedFieldAliases).addElement((Object)alias);
            } else {
                LocalContext local = new LocalContext(AbstractTokensCell.this.getContext());
                s = kp.getSuggestion(local, matchingText, completionStart, completionEnd);
            }
            this.addSuggestion(kp, s, matchingText);
            return this.canAdd();
        }

        private boolean isAdded(Object object) {
            return SetSequence.fromSet(this.alreadyAdded).contains(object);
        }

        private void addSuggestion(Object object, @Nullable Suggestion s, String matchingText) {
            if (s == null) {
                return;
            }
            SetSequence.fromSet(this.alreadyAdded).addElement(object);
            if (AbstractTokensCell.this.command.isError()) {
                s.setComplete(false);
            }
            if (matchingText.equalsIgnoreCase(s.getOption())) {
                ListSequence.fromList(this.vipItems).addElement((Object)s);
            } else {
                ListSequence.fromList(this.otherItems).addElement((Object)s);
            }
            --this.max;
        }
    }
}

