/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.commands.impl.AddCommentCommandExecutor;
import jetbrains.youtrack.commands.impl.CommandTypeCell;
import jetbrains.youtrack.parser.api.IPrefixTreesData;
import jetbrains.youtrack.parser.api.IWord;
import jetbrains.youtrack.parser.base.SuggestItem;
import org.jetbrains.annotations.NotNull;

public class CommandList
implements ICommandList {
    @NotNull
    private List<IWord> tokens;
    private List<ICommand> commands;
    private Map<IField, ICommand> fieldToCommand;
    private String text;
    private IPrefixTreesData prefixTrees;
    @NotNull
    private IContext context;

    CommandList(String text, @NotNull List<IWord> tokens, IPrefixTreesData data, @NotNull IContext context2) {
        this.tokens = tokens;
        this.commands = ListSequence.fromList((List)new LinkedList());
        this.fieldToCommand = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        this.text = text;
        this.prefixTrees = data;
        this.context = context2;
    }

    public IContext getContext() {
        return this.context;
    }

    public List<IWord> getTokens() {
        return this.tokens;
    }

    public void addCommand(ICommand command) {
        if (command == null) {
            return;
        }
        ListSequence.fromList(this.commands).addElement((Object)command);
        if (command.getCommandExecutor() != null && command.getCommandExecutor().getField() != null) {
            MapSequence.fromMap(this.fieldToCommand).put((Object)command.getCommandExecutor().getField(), (Object)command);
        }
    }

    public void removeCommand(ICommand command) {
        if (command == null) {
            return;
        }
        ListSequence.fromList(this.commands).removeElement((Object)command);
        if (command.getCommandExecutor() != null && command.getCommandExecutor().getField() != null) {
            MapSequence.fromMap(this.fieldToCommand).removeKey((Object)command.getCommandExecutor().getField());
        }
    }

    public String getText() {
        return this.text;
    }

    public IPrefixTreesData getPrefixTrees() {
        return this.prefixTrees;
    }

    public Iterable<ICommand> getCommands() {
        return this.commands;
    }

    public Iterable<ICommand> getValidCommands() {
        return ListSequence.fromList(this.commands).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommand>(){

            public boolean accept(ICommand it) {
                return !(it instanceof AddCommentCommandExecutor) && (it.getCommandExecutor() != null || it.isError());
            }
        });
    }

    public ICommandExecutor getCommandExecutor(IField field) {
        ICommand c = (ICommand)MapSequence.fromMap(this.fieldToCommand).get((Object)field);
        return c == null ? null : c.getCommandExecutor();
    }

    private ICell findCell(int pos) {
        for (ICommand command : ListSequence.fromList(this.commands)) {
            ICell c = command.findCell(pos);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public ICell getLastCell() {
        if (ListSequence.fromList(this.commands).isEmpty()) {
            return null;
        }
        return ((ICommand)ListSequence.fromList(this.commands).last()).getLastCell();
    }

    public Iterable<ICell> getCells() {
        return ListSequence.fromList(this.commands).translate((_FunctionTypes._return_P1_E0)new ITranslator2<ICommand, ICell>(){

            public Iterable<ICell> translate(ICommand it) {
                return it.getCells();
            }
        });
    }

    public int getCellIndex(ICell cell) {
        int i = 0;
        for (ICell c : this.getCells()) {
            if (c == cell) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Cell not found.");
    }

    public ICell getCell(int index) {
        int i = 0;
        for (ICell c : this.getCells()) {
            if (i++ != index) continue;
            return c;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void execute() {
        this.execute(true);
    }

    public void execute(boolean flushPages) {
        int nextPageStart = 1000;
        int current = 0;
        ISequence executors = ListSequence.fromList(this.commands).select((_FunctionTypes._return_P1_E0)new ISelector<ICommand, ICommandExecutor>(){

            public ICommandExecutor select(ICommand it) {
                return it.getCommandExecutor();
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommandExecutor>(){

            public boolean accept(ICommandExecutor it) {
                return it != null;
            }
        });
        executors = Sequence.fromIterable((Iterable)executors).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommandExecutor>(){

            public boolean accept(ICommandExecutor it) {
                return !it.isTailCommand();
            }
        }).concat(Sequence.fromIterable((Iterable)executors).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommandExecutor>(){

            public boolean accept(ICommandExecutor it) {
                return it.isTailCommand();
            }
        })).toListSequence();
        for (Entity issue : Sequence.fromIterable((Iterable)this.context.getSelectedIssues()).toListSequence()) {
            if (current++ >= nextPageStart && flushPages) {
                DnqUtils.getCurrentTransientSession().flush();
                nextPageStart += 1000;
            }
            for (ICommandExecutor executor : Sequence.fromIterable((Iterable)executors)) {
                executor.execute(issue);
            }
        }
        if (current != 0 && flushPages) {
            DnqUtils.getCurrentTransientSession().flush();
        }
    }

    public String getDebugDescription() {
        final StringBuilder sb = new StringBuilder();
        ListSequence.fromList(this.commands).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ICommand>(){

            public void visit(ICommand it) {
                sb.append("[").append(it.getDebugDescription()).append("]");
            }
        });
        return sb.toString();
    }

    public Iterable<SuggestItem> getSuggestions(int cursorPos) {
        ICell cell = this.findCell(cursorPos);
        Iterable suggestions = cell == null ? SuggestItem.EMPTY : cell.getSuggestions(cursorPos);
        return suggestions;
    }

    public boolean hasDeleteIssueCommand() {
        for (ICell cell : Sequence.fromIterable(this.getCells())) {
            CommandTypeCell ctc;
            if (!(cell instanceof CommandTypeCell) || !(ctc = (CommandTypeCell)cell).isDeleteIssueCommandTypeCell()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        return ListSequence.fromList(this.commands).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommand>(){

            public boolean accept(ICommand it) {
                return it.isError();
            }
        }).isNotEmpty();
    }
}

