/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.parser.LocalContext;
import jetbrains.youtrack.api.parser.Suggestable;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import jetbrains.youtrack.parser.api.IPredicate;
import org.jetbrains.annotations.NotNull;

public class CommandType
implements Suggestable {
    private Entity linkPrototype;
    private boolean outward;
    private PredefinedCommandType predefined;
    private final boolean shouldSuggest;

    public CommandType(PredefinedCommandType predefined) {
        this(predefined, true);
    }

    public CommandType(PredefinedCommandType predefined, boolean shouldSuggest) {
        this.predefined = predefined;
        this.shouldSuggest = shouldSuggest;
    }

    public CommandType(Entity linkPrototype, boolean outward) {
        this(linkPrototype, outward, true);
    }

    public CommandType(Entity linkPrototype, boolean outward, boolean shouldSuggest) {
        this.linkPrototype = linkPrototype;
        this.outward = outward;
        this.shouldSuggest = shouldSuggest;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Suggestion getSuggestion(@NotNull LocalContext context2, String matching, int completionStart, int completionEnd) {
        if (!this.shouldSuggest) {
            return null;
        }
        if (this.isPredefined()) {
            return new Suggestion(this.predefined.getName(ApplicationMetaDataImpl.getLocale()), ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandType.command", new Object[0]), completionStart, completionEnd, 0, matching.length(), SuggestionType.COMMAND_TYPE);
        }
        return new Suggestion(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)this.linkPrototype, (String)"IssueLinkPrototype")).getRoleName(this.outward, this.linkPrototype), ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandType.link_type", new Object[0]), completionStart, completionEnd, 0, matching.length(), SuggestionType.COMMAND_TYPE);
    }

    public boolean isPredefined() {
        return this.predefined != null;
    }

    public boolean isLink() {
        return !EntityOperations.equals((Entity)this.linkPrototype, null);
    }

    public PredefinedCommandType getPredefinedCommandType() {
        return this.predefined;
    }

    public Entity getLinkPrototype() {
        return this.linkPrototype;
    }

    public boolean getOuward() {
        return this.outward;
    }

    public boolean isPrimary() {
        return true;
    }

    public static IPredicate createPredicate(final Entity linkPrototype, final boolean outward) {
        return new IPredicate<CommandType>(){

            public boolean matches(CommandType value) {
                return EntityOperations.equals((Entity)value.linkPrototype, (Object)linkPrototype) && value.outward == outward;
            }
        };
    }
}

