/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.security.IssueSecurityService;
import jetbrains.youtrack.commands.impl.BaseCommandExecutor;
import jetbrains.youtrack.core.security.Operation;

public class DeleteIssueCommandExecutor
extends BaseCommandExecutor
implements ICommandExecutor {
    public String getDebugDescription() {
        return "Delete issue(s)";
    }

    public String getPresentation() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("DeleteIssueCommandExecutor.Delete_issue_s", new Object[0]);
    }

    public void execute(Entity issue) {
        if (EntityOperations.isRemoved((Entity)issue)) {
            return;
        }
        if (!((IssueSecurityService)ServiceLocator.getBean((String)"issueSecurityService")).isAccessible(issue, Operation.DELETE)) {
            throw new SecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("DeleteIssueCommandExecutor.You_don_t_have_permissions_to_delete_issue", new Object[0]));
        }
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).delete(issue);
    }
}

