/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueFieldValue;
import jetbrains.charisma.persistent.ProjectMatcher;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.parser.api.IPredicate;

public class HasIssuePermissionPredicate
implements IPredicate<IFieldValue> {
    public boolean matches(IFieldValue value) {
        if (value instanceof ProjectMatcher) {
            ProjectMatcher matcher = (ProjectMatcher)value;
            return this.hasPermissionForProject(matcher.getProject());
        }
        if (value instanceof IssueFieldValue) {
            IssueFieldValue field = (IssueFieldValue)value;
            Entity issue = field.getIssueEntity();
            return this.hasPermissionForProject(EntityOperations.equals((Entity)issue, null) ? null : AssociationSemantics.getToOne((Entity)issue, (String)"project"));
        }
        return true;
    }

    private boolean hasPermissionForProject(Entity project) {
        Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        return !EntityOperations.equals((Entity)project, null) ? ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission(Permission.READ_ISSUE, project, currentUser) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission(Permission.CREATE_ISSUE, project, currentUser) : ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission(Permission.READ_ISSUE, currentUser) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission(Permission.CREATE_ISSUE, currentUser);
    }
}

