/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ICollectionSequence;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;

public class IssueDisassembler {
    private static Set<String> EXCLUDE_TYPES = new HashSet<String>(Arrays.asList("text", "string"));
    private Entity issue;
    private List<String> commands = ListSequence.fromList(new ArrayList());

    public IssueDisassembler(Entity issue) {
        this.issue = issue;
        this.generateFieldCommands();
        this.generateLinkCommands();
        this.generateVisibilityCommands();
        this.generateTagCommands();
    }

    public Iterable<String> getCommands() {
        return this.commands;
    }

    private void generateFieldCommands() {
        final Entity loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        IListSequence customFields = Sequence.fromIterable((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).getAccessibleCustomFields(loggedInUser, this.issue)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isWriteAccessible(IssueDisassembler.this.issue, loggedInUser, it) && !((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).hasDefaultValue(IssueDisassembler.this.issue, it);
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EXCLUDE_TYPES.contains(((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getType(AssociationSemantics.getToOne((Entity)it, (String)"prototype")).getValueType().toLowerCase());
            }
        }).toListSequence();
        for (Entity customField : ListSequence.fromList((List)customFields)) {
            if (((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).isMultivalue(customField)) {
                ICollectionSequence multivalueCommand = CollectionSequence.fromCollection(new ArrayList());
                for (String value : Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).getValuePresentation(this.issue, customField).split(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandUtil.", new Object[0]))))) {
                    CollectionSequence.fromCollection((Collection)multivalueCommand).addElement((Object)((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"name", String.class, null) + " " + value));
                }
                this.commands.add(IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand), (String)" "));
                continue;
            }
            this.commands.add((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"name", String.class, null) + " " + ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).getValueRenderer(customField).getPresentation(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"CustomFieldPrototype")).getValue(this.issue, AssociationSemantics.getToOne((Entity)customField, (String)"prototype")), DetalizationLevel.COMMAND));
        }
    }

    private void generateLinkCommands() {
        for (Entity linkPrototype : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"IssueLinkPrototype"))) {
            Iterable links = IssueLinkPrototypeUtil.getLinkedIssues((Entity)this.issue, (Entity)linkPrototype, (boolean)true);
            if (!QueryOperations.isEmpty((Iterable)links)) {
                for (Entity linkedIssue : Sequence.fromIterable((Iterable)links)) {
                    this.commands.add(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkPrototype, (String)"IssueLinkPrototype")).getDefaultLocaleRoleName(true, linkPrototype) + " " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue));
                }
            }
            if (QueryOperations.isEmpty((Iterable)(links = IssueLinkPrototypeUtil.getLinkedIssues((Entity)this.issue, (Entity)linkPrototype, (boolean)false)))) continue;
            for (Entity linkedIssue : Sequence.fromIterable((Iterable)links)) {
                this.commands.add(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkPrototype, (String)"IssueLinkPrototype")).getDefaultLocaleRoleName(false, linkPrototype) + " " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue));
            }
        }
    }

    private void generateVisibilityCommands() {
        ICollectionSequence multivalueCommand;
        String visibleToPresentation = ((IField)ServiceLocator.getBean((String)"predefinedFieldVisibleTo")).getPresentation();
        if (!QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)this.issue, (String)"permittedGroup"))) {
            multivalueCommand = CollectionSequence.fromCollection(new ArrayList());
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)this.issue, (String)"permittedGroup")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Collection)multivalueCommand, visibleToPresentation){
                final /* synthetic */ Collection val$multivalueCommand;
                final /* synthetic */ String val$visibleToPresentation;
                {
                    this.val$multivalueCommand = collection;
                    this.val$visibleToPresentation = string;
                }

                public void visit(Entity it) {
                    CollectionSequence.fromCollection((Collection)this.val$multivalueCommand).addElement((Object)(this.val$visibleToPresentation + " " + (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale())));
                }
            });
            this.commands.add(IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand), (String)" "));
        }
        if (!QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)this.issue, (String)"permittedUser"))) {
            multivalueCommand = CollectionSequence.fromCollection(new ArrayList());
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)this.issue, (String)"permittedUser")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Collection)multivalueCommand, visibleToPresentation){
                final /* synthetic */ Collection val$multivalueCommand;
                final /* synthetic */ String val$visibleToPresentation;
                {
                    this.val$multivalueCommand = collection;
                    this.val$visibleToPresentation = string;
                }

                public void visit(Entity it) {
                    CollectionSequence.fromCollection((Collection)this.val$multivalueCommand).addElement((Object)(this.val$visibleToPresentation + " " + (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"login", String.class, (Object)"<no user>")));
                }
            });
            this.commands.add(IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand), (String)" "));
        }
    }

    private void generateTagCommands() {
        ICollectionSequence tags = CollectionSequence.fromCollection(new ArrayList());
        for (Entity tag : Sequence.fromIterable((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).getTags(this.issue))) {
            CollectionSequence.fromCollection((Collection)tags).addElement((Object)("tag " + (String)PrimitiveAssociationSemantics.get((Entity)tag, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())));
        }
        if (CollectionSequence.fromCollection((Collection)tags).isNotEmpty()) {
            this.commands.add(IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)tags), (String)" "));
        }
    }
}

