/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.ui;

import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

class CommandRestUtil {
    private CommandRestUtil() {
    }

    public static Iterable<Entity> toIssues(String issueIds) {
        if (issueIds == null || issueIds.length() == 0) {
            return QueryOperations.empty((String)"Issue");
        }
        final int issueTypeId = ((PersistentEntityStoreImpl)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore"))).getEntityTypeId("Issue", false);
        return Sequence.fromIterable(CommandRestUtil.toLongs(issueIds)).select((_FunctionTypes._return_P1_E0)new ISelector<Long, Entity>(){

            public Entity select(Long it) {
                return CommandRestUtil.toIssue(issueTypeId, it);
            }
        }).toListSequence();
    }

    public static Iterable<Long> toLongs(String issueIds) {
        final Wrappers._long prev = new Wrappers._long(0L);
        return Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])issueIds.split("-"))).select((_FunctionTypes._return_P1_E0)new ISelector<String, Long>(){

            public Long select(String it) {
                prev.value = CommandRestUtil.stringToLong(it, prev.value);
                return prev.value;
            }
        });
    }

    static long stringToLong(String s, long prev) {
        long res = 0L;
        int pow = 1;
        for (int i = s.length() - 1; i >= 0; --i) {
            res += (long)(CommandRestUtil.decodeChar(s.charAt(i)) * pow);
            pow *= 64;
        }
        return res + prev;
    }

    static int decodeChar(char c) {
        if (c <= '9') {
            return c - 48;
        }
        if (c <= 'Z') {
            return c - 65 + 10;
        }
        return c - 97 + 36;
    }

    static Entity toIssue(int issueTypeId, long issueId) {
        PersistentEntityId id = new PersistentEntityId(issueTypeId, issueId);
        return DnqUtils.cast((Object)((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession().getEntity((EntityId)id), (String)"Issue");
    }
}

