/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mazine.infer.type.parameter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mazine.infer.type.parameter.InferHierarchyTypeKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a8\u0006\u0006"}, d2={"isOverriding", "", "overridingMethod", "Ljava/lang/reflect/Method;", "superMethod", "Lkotlin/reflect/KFunction;", "infer-hierarchy-type-parameter"})
public final class MethodOverrideKt {
    public static final boolean isOverriding(@NotNull Method overridingMethod, @NotNull Method superMethod) {
        boolean bl;
        block15: {
            Object[] superParameterTypes;
            Intrinsics.checkParameterIsNotNull((Object)overridingMethod, (String)"overridingMethod");
            Intrinsics.checkParameterIsNotNull((Object)superMethod, (String)"superMethod");
            if (Intrinsics.areEqual((Object)superMethod, (Object)overridingMethod)) {
                return true;
            }
            Class<?> clazz = superMethod.getDeclaringClass();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
            Class<?> superDeclaringClass = clazz;
            Class<?> clazz2 = overridingMethod.getDeclaringClass();
            if (clazz2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
            Class<?> overridingDeclaringClass = clazz2;
            if (!superDeclaringClass.isAssignableFrom(overridingDeclaringClass)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)overridingMethod.getName(), (Object)superMethod.getName()) ^ true) {
                return false;
            }
            Object[] overridingParameterTypes = overridingMethod.getGenericParameterTypes();
            if (overridingParameterTypes.length != (superParameterTypes = superMethod.getGenericParameterTypes()).length) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)overridingParameterTypes, (String)"overridingParameterTypes");
            Intrinsics.checkExpressionValueIsNotNull((Object)superParameterTypes, (String)"superParameterTypes");
            Iterable $receiver$iv = ArraysKt.zip((Object[])overridingParameterTypes, (Object[])superParameterTypes);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    Pair $overridingType_superType = (Pair)element$iv;
                    Type overridingType = (Type)$overridingType_superType.component1();
                    Type superType = (Type)$overridingType_superType.component2();
                    Type type = superType;
                    if (type instanceof Class) {
                        bl2 = Intrinsics.areEqual((Object)overridingType, (Object)superType);
                    } else if (type instanceof TypeVariable) {
                        Object d = ((TypeVariable)superType).getGenericDeclaration();
                        if (Intrinsics.areEqual(d, superDeclaringClass)) {
                            String string = ((TypeVariable)superType).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"superType.name");
                            Type inferredTypeParameter = InferHierarchyTypeKt.inferTypeParameter(superDeclaringClass, string, overridingDeclaringClass);
                            bl2 = overridingType instanceof Class ? Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaObjectType((KClass)JvmClassMappingKt.getKotlinClass((Class)((Class)overridingType))), (Object)inferredTypeParameter) : Intrinsics.areEqual((Object)overridingType, (Object)inferredTypeParameter);
                        } else {
                            bl2 = Intrinsics.areEqual(d, (Object)superMethod) ? overridingType instanceof TypeVariable && Intrinsics.areEqual(((TypeVariable)overridingType).getGenericDeclaration(), (Object)overridingMethod) : false;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isOverriding(@NotNull KFunction<?> $receiver, @NotNull KFunction<?> superMethod) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(superMethod, (String)"superMethod");
        Method method = ReflectJvmMapping.getJavaMethod($receiver);
        if (method == null) {
            throw (Throwable)new IllegalArgumentException("Function cannot be represented as Java method");
        }
        Method method2 = ReflectJvmMapping.getJavaMethod(superMethod);
        if (method2 == null) {
            throw (Throwable)new IllegalArgumentException("Function cannot be represented as Java method");
        }
        return MethodOverrideKt.isOverriding(method, method2);
    }
}

