/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util;

import com.jetbrains.bundle.hub_client.util.validation.ClientCertificateRequiredException;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlRedirectionException;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidationException;
import com.jetbrains.bundle.hub_client.util.validation.UntrustedServerCertificateException;
import com.jetbrains.service.util.ssl.CertRequestInfo;
import com.jetbrains.service.util.ssl.CompositeX509KeyManager;
import com.jetbrains.service.util.ssl.CompositeX509TrustManager;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.client.ClientBuilder;
import jetbrains.jetpass.client.accounts.ServiceCredentialsValidationResult;
import jetbrains.jetpass.client.hub.HubClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubClientProvider {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, HubClient> hubClients = new ConcurrentHashMap();
    private final Object hubClientsMonitor = new Object();
    private CompositeX509KeyManager compositeX509KeyManager;
    private CompositeX509TrustManager compositeX509TrustManager;
    private KeyStore additionalKeyStore;
    private String additionalHubKeyPassword;
    private KeyStore temporaryKeyStore;
    private int hubConnectionTimeoutInMillis = Integer.getInteger("bundle.hub.connection.timeout", 15000);
    private int hubReadTimeoutInMillis = Integer.getInteger("bundle.hub.read.timeout", 15000);

    public HubClientProvider() {
        this(null, null);
    }

    public HubClientProvider(@Nullable KeyStore additionalKeyStore, @Nullable String additionalHubKeyPassword) {
        this.additionalKeyStore = additionalKeyStore;
        this.additionalHubKeyPassword = additionalHubKeyPassword;
        this.createTemporaryKeyStore();
    }

    private void rebuildCompositeManagers() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        this.compositeX509KeyManager = KeystoreUtil.buildCompositeKeyManager((KeyStore)this.additionalKeyStore, (String)this.additionalHubKeyPassword, (KeyStore)this.temporaryKeyStore);
        this.compositeX509TrustManager = KeystoreUtil.buildCompositeTrustManager((KeyStore[])new KeyStore[]{this.additionalKeyStore, this.temporaryKeyStore});
    }

    private void createTemporaryKeyStore() {
        try {
            this.temporaryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.temporaryKeyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("SSL settings exception: " + e.getMessage(), e);
        }
    }

    @NotNull
    public HubClient getHubClient(String hubUrl) throws HubUrlValidationException {
        return this.validateAndRememberHubClient(hubUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HubClient validateAndRememberHubClient(String hubUrl, boolean replaceIfAdded) throws HubUrlValidationException {
        HubClient hubClient = this.hubClients.get(hubUrl);
        if (hubClient == null || replaceIfAdded) {
            Object object = this.hubClientsMonitor;
            synchronized (object) {
                hubClient = this.hubClients.get(hubUrl);
                if (hubClient == null || replaceIfAdded) {
                    hubClient = this.buildAndValidateHubClient(hubUrl);
                    this.hubClients.put(hubUrl, hubClient);
                }
            }
        }
        return hubClient;
    }

    private HubClient buildHubClient(@NotNull String hubUrl) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        this.rebuildCompositeManagers();
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(new KeyManager[]{this.compositeX509KeyManager}, new TrustManager[]{this.compositeX509TrustManager}, null);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.sslContext(context);
        HubClient.HubClientBuilder hubClientBuilder = HubClient.Companion.builder(clientBuilder).baseUrl(hubUrl);
        hubClientBuilder.connectTimeout(Integer.valueOf(this.hubConnectionTimeoutInMillis));
        hubClientBuilder.readTimeout(Integer.valueOf(this.hubReadTimeoutInMillis));
        return hubClientBuilder.build();
    }

    private HubClient buildAndValidateHubClient(@NotNull String hubUrl) throws HubUrlValidationException {
        try {
            HubClient hubClient = this.buildHubClient(hubUrl);
            ServiceCredentialsValidationResult checkResult = hubClient.getAccountsClient().checkServiceCredentials();
            switch (checkResult.getStatus()) {
                case OK: 
                case SERVICE_CREDENTIALS_UNDEFINED: {
                    return hubClient;
                }
                case CANT_CONNECT: {
                    X509Certificate[] lastCheckedChain;
                    if (checkResult.getCause() instanceof SSLHandshakeException && (lastCheckedChain = this.compositeX509TrustManager.getLastCheckedChain()) != null && lastCheckedChain.length > 0 && lastCheckedChain[0] != null) {
                        X509Certificate certificate = lastCheckedChain[0];
                        String alias = hubUrl + "-" + certificate.getSerialNumber();
                        this.temporaryKeyStore.setCertificateEntry(alias, certificate);
                        hubClient = this.buildHubClient(hubUrl);
                        ServiceCredentialsValidationResult secondCheckResult = hubClient.getAccountsClient().checkServiceCredentials();
                        this.temporaryKeyStore.deleteEntry(alias);
                        switch (secondCheckResult.getStatus()) {
                            case OK: 
                            case SERVICE_CREDENTIALS_UNDEFINED: {
                                X509Certificate[] untrustedChain = this.buildFullUntrustedChain(lastCheckedChain);
                                this.LOG.debug("UntrustedServerCertificateException in buildAndValidateHubClient. Hub url {}", (Object)hubUrl);
                                throw new UntrustedServerCertificateException("Server SSL certificate not trusted.", checkResult.getStatus(), checkResult.getCause(), untrustedChain, untrustedChain.length > lastCheckedChain.length);
                            }
                            case WRONG_URL: {
                                CertRequestInfo lastCertRequestInfo = this.compositeX509KeyManager.getLastCertRequestInfo();
                                if (lastCertRequestInfo == null || lastCertRequestInfo.getAlias() != null) break;
                                this.LOG.debug("ClientCertificateRequiredException in buildAndValidateHubClient. Hub url {}", (Object)hubUrl);
                                throw new ClientCertificateRequiredException("Client SSL certificate not found. Please, provide additional keystore with required certificate.", secondCheckResult.getStatus(), secondCheckResult.getCause(), lastCertRequestInfo);
                            }
                            default: {
                                checkResult = secondCheckResult;
                            }
                        }
                    }
                    this.LOG.debug("Cannot connect to Hub url {}. Status {}: {}. Reason: {}", new Object[]{hubUrl, checkResult.getStatus().name(), checkResult.getStatus().getMessage(), checkResult.getCause()});
                    throw new HubUrlValidationException(checkResult.getMessage(), checkResult.getStatus(), checkResult.getCause());
                }
                case WRONG_URL: {
                    CertRequestInfo lastCertRequestInfo = this.compositeX509KeyManager.getLastCertRequestInfo();
                    if (lastCertRequestInfo != null && lastCertRequestInfo.getAlias() == null) {
                        this.LOG.debug("ClientCertificateRequiredException in buildAndValidateHubClient. Hub url {}", (Object)hubUrl);
                        throw new ClientCertificateRequiredException("Client SSL certificate not found. Please, provide additional keystore with required certificate.", checkResult.getStatus(), checkResult.getCause(), lastCertRequestInfo);
                    }
                    Throwable cause = checkResult.getCause();
                    if (!(cause instanceof RedirectionException)) break;
                    RedirectionException exception = (RedirectionException)cause;
                    this.LOG.debug("RedirectionException in buildAndValidateHubClient. Hub url {}", (Object)hubUrl, (Object)exception);
                    throw new HubUrlRedirectionException("Hub URL must not response with redirect: " + checkResult.getMessage(), checkResult.getStatus(), exception);
                }
            }
            this.LOG.debug("Cannot use url {}. Status {}: {}. Reason: {}", new Object[]{hubUrl, checkResult.getStatus().name(), checkResult.getStatus().getMessage(), checkResult.getCause()});
            String checkResultMessage = checkResult.getMessage();
            throw new HubUrlValidationException(checkResultMessage != null && checkResultMessage.startsWith("Unknown target response") ? "Unknown target response" : checkResultMessage, checkResult.getStatus(), checkResult.getCause());
        }
        catch (HubUrlValidationException e) {
            this.LOG.debug("Rethrow HubUrlValidationException in buildAndValidateHubClient. Hub url {}", (Object)hubUrl, (Object)e);
            throw e;
        }
        catch (Exception e) {
            this.LOG.debug("Exception in buildAndValidateHubClient. Hub url {}", (Object)hubUrl, (Object)e);
            throw new HubUrlValidationException(e.getMessage(), ServiceCredentialsValidationResult.Status.OTHER, e);
        }
    }

    private X509Certificate[] buildFullUntrustedChain(X509Certificate[] lastCheckedChain) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        X509Certificate[] acceptedIssuers;
        X509Certificate lastChainCertificate = lastCheckedChain[lastCheckedChain.length - 1];
        this.LOG.debug("Try to verify last certificate: " + lastChainCertificate.getSubjectDN().getName());
        if (this.isSelfSigned(lastChainCertificate)) {
            this.LOG.debug("last certificate is self-signed!");
            return lastCheckedChain;
        }
        String issuerName = lastChainCertificate.getIssuerDN().getName();
        this.LOG.debug("Expected issuer: " + issuerName);
        for (X509Certificate issuer : acceptedIssuers = this.compositeX509TrustManager.getAcceptedIssuers()) {
            if (!issuer.getIssuerDN().getName().equals(issuerName)) continue;
            try {
                PublicKey publicKey = issuer.getPublicKey();
                lastChainCertificate.verify(publicKey);
                this.LOG.debug("Found! " + issuer.getIssuerDN().getName());
                X509Certificate[] chain = new X509Certificate[lastCheckedChain.length + 1];
                System.arraycopy(lastCheckedChain, 0, chain, 0, lastCheckedChain.length);
                chain[lastCheckedChain.length] = issuer;
                return chain;
            }
            catch (InvalidKeyException | NoSuchProviderException | SignatureException exception) {
                this.LOG.trace("Cannot verify with " + issuer.getIssuerDN().getName());
            }
        }
        return lastCheckedChain;
    }

    private boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (InvalidKeyException | SignatureException e) {
            return false;
        }
    }
}

