/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util;

import com.jetbrains.bundle.hub_client.util.HubServiceCheckResult;
import com.jetbrains.service.util.ConfiguratorUtils;
import java.util.List;
import java.util.UUID;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.ServiceCredentialsValidationResult;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubUtil {
    private static Logger getLogger() {
        return LoggerFactory.getLogger(HubUtil.class);
    }

    @NotNull
    public static HubServiceCheckResult checkService(BaseAccountsClient accountsClient) {
        ServiceCredentialsValidationResult validationResult = accountsClient.checkServiceCredentials();
        switch (validationResult.getStatus()) {
            case SERVICE_NOT_REGISTERED: {
                return new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, validationResult.getCause());
            }
            case SERVICE_WRONG_SECRET: {
                return new HubServiceCheckResult(HubServiceCheckResult.Status.EXISTS_WRONG_SECRET, validationResult.getCause());
            }
            case SERVICE_NOT_VERIFIED: {
                return new HubServiceCheckResult(HubServiceCheckResult.Status.EXISTS_NOT_VERIFIED, validationResult.getCause());
            }
            case OK: {
                return new HubServiceCheckResult(HubServiceCheckResult.Status.EXISTS_VERIFIED, null);
            }
        }
        return new HubServiceCheckResult(HubServiceCheckResult.Status.CANNOT_CHECK, validationResult.getCause());
    }

    @NotNull
    public static BaseAccountsClient getAccountsClientByIdAndSecret(HubClient hubClient, String clientId, String clientSecret) {
        return hubClient.getAccountsClient(clientId, clientSecret, new String[0]);
    }

    @NotNull
    public static ServiceClient getServiceClientByIdAndSecret(HubClient hubClient, String clientId, String clientSecret) {
        return hubClient.getAccountsClient(clientId, clientSecret, new String[0]).getServiceClient();
    }

    @NotNull
    public static ServiceClient getAnonymousHubServiceClient(HubClient hubClient) {
        return hubClient.getAccountsClient().getServiceClient();
    }

    @NotNull
    public static ServiceClient getBasicAuthorizationHubServiceClient(HubClient hubClient) {
        throw new UnsupportedOperationException("Implement service client with basic authorization");
    }

    @NotNull
    public static ServiceJSON createEmptyVerifiedService(ServiceClient serviceClient, @NotNull String serviceIdInHub, @NotNull String serviceSecret, @NotNull String serviceName, List<String> redirectUris) {
        return HubUtil.createEmptyVerifiedService(serviceClient, serviceIdInHub, serviceSecret, serviceName, null, null, null, null, null, redirectUris);
    }

    @NotNull
    public static ServiceJSON createEmptyVerifiedService(ServiceClient serviceClient, @NotNull String serviceIdInHub, @NotNull String serviceSecret, @Nullable String serviceName, @Nullable String serviceLicenseName, @Nullable String serviceLicenseKey, @Nullable String serviceApplicationName, @Nullable String serviceManufacturer, @Nullable String serviceVersion, List<String> redirectUris) {
        ServiceJSON serviceJSON = new ServiceJSON();
        serviceJSON.setId(serviceIdInHub);
        serviceJSON.setName(serviceName);
        serviceJSON.setApplicationName(serviceApplicationName);
        serviceJSON.setVendor(serviceManufacturer);
        serviceJSON.setVersion(serviceVersion);
        serviceJSON.setSecret(serviceSecret);
        serviceJSON.setTrusted(Boolean.valueOf(true));
        if (redirectUris != null && !redirectUris.isEmpty()) {
            serviceJSON.setRedirectUris(redirectUris);
        }
        if (serviceLicenseName != null && serviceLicenseKey != null) {
            LicenseJSON licenseSettings = new LicenseJSON();
            licenseSettings.setLicenseName(serviceLicenseName);
            licenseSettings.setLicenseKey(serviceLicenseKey);
            serviceJSON.setLicenseSettings(licenseSettings);
        }
        return serviceClient.createService(serviceJSON, new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.ID, Partial.Service.TRUSTED}));
    }

    @NotNull
    public static HubServiceCheckResult checkService(HubClient hubClient, @NotNull String serviceId, @NotNull String serviceSecret) {
        return HubUtil.checkService(hubClient.getAccountsClient(serviceId, serviceSecret, new String[0]));
    }

    public static ServiceJSON createService(@NotNull HubClient hubClient, @NotNull String serviceId, @NotNull String serviceSecret, @NotNull String serviceName, List<String> redirectUris) {
        return HubUtil.createService(hubClient, serviceId, serviceSecret, serviceName, null, null, null, redirectUris);
    }

    public static ServiceJSON createService(@NotNull HubClient hubClient, @NotNull String serviceId, @NotNull String serviceSecret, @NotNull String serviceName, @Nullable String serviceApplicationName, @Nullable String serviceManufacturer, @Nullable String serviceVersion, List<String> redirectUris) {
        ServiceClient clientForServiceCreation = HubUtil.getAnonymousHubServiceClient(hubClient);
        return HubUtil.createService(clientForServiceCreation, serviceId, serviceSecret, serviceName, serviceApplicationName, serviceManufacturer, serviceVersion, redirectUris);
    }

    @NotNull
    public static ServiceJSON createService(@NotNull ServiceClient clientForServiceCreation, @NotNull String serviceId, @NotNull String serviceSecret, @NotNull String serviceName, @Nullable String serviceApplicationName, @Nullable String serviceManufacturer, @Nullable String serviceVersion, List<String> redirectUris) {
        ServiceJSON serviceJSON = HubUtil.createEmptyVerifiedService(clientForServiceCreation, serviceId, serviceSecret, serviceName, null, null, serviceApplicationName, serviceManufacturer, serviceVersion, redirectUris);
        Boolean isVerified = serviceJSON.isTrusted();
        HubUtil.getLogger().debug("Hub service was created: serviceId = {}, isVerified = {}", (Object)serviceId, (Object)isVerified);
        return serviceJSON;
    }

    public static void deleteHubService(HubClient hubClient, @NotNull String serviceId, @NotNull String serviceSecret) {
        Boolean bundleHubServiceExists = HubUtil.checkService(hubClient, serviceId, serviceSecret).exists();
        try {
            if (bundleHubServiceExists == null) {
                HubUtil.getLogger().error(String.format("Cannot delete service in Hub (id = %s), because cannot check that service exists.", serviceId));
            } else if (bundleHubServiceExists.booleanValue()) {
                ServiceClient serviceClient = HubUtil.getServiceClientByIdAndSecret(hubClient, serviceId, serviceSecret);
                serviceClient.deleteService(serviceId);
            }
        }
        catch (Exception e) {
            HubUtil.getLogger().error(String.format("Cannot delete service in Hub (id = %s). It's expected for Hub <= 0.9. See JPS-1789.", serviceId), (Throwable)e);
        }
    }

    @NotNull
    public static String generateHubServiceId() {
        return UUID.randomUUID().toString();
    }

    @NotNull
    public static String generateHubServiceSecret() {
        return ConfiguratorUtils.randomAlphanumeric((int)50);
    }

    public static String getHubServiceId(@NotNull HubClient hubClient) {
        return hubClient.getOAuthClient().getHubScope();
    }

    @Nullable
    public static String getHubHomeUrl(@NotNull ServiceClient serviceClient, @NotNull String hubServiceId) {
        try {
            ServiceJSON service = serviceClient.getService(hubServiceId, new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.ID, Partial.Service.HOME_URL}));
            if (service != null) {
                return service.getHomeUrl();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

