/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationResult {
    public static final String ERRORS_PROPERTY = "errors";
    public static final String ADDITIONAL_INFO_PROPERTY = "additionalInfo";
    private Set<ErrorInfo> errors = new HashSet<ErrorInfo>();
    private HashMap<String, Object> additionalInfo = new HashMap();

    @JsonProperty(value="errors")
    public ErrorInfo[] getErrors() {
        return this.errors.toArray(new ErrorInfo[this.errors.size()]);
    }

    @JsonProperty(value="additionalInfo")
    public HashMap<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void addError(@NotNull Enum error, @NotNull String fieldName, @NotNull String message, @Nullable Map<String, String> parameters) {
        this.errors.add(new ErrorInfo(error.name(), message, parameters, fieldName));
    }

    public void addError(@NotNull Enum error, @NotNull String fieldName, @NotNull String message) {
        this.addError(error, fieldName, message, null);
    }

    public void addError(ErrorInfo errorInfo) {
        this.errors.add(errorInfo);
    }

    public void addInfo(String key, Object info) {
        this.additionalInfo.put(key, info);
    }

    public boolean hasErrorForField(@NotNull String field) {
        for (ErrorInfo error : this.errors) {
            if (!field.equals(error.getField())) continue;
            return true;
        }
        return false;
    }

    public ErrorInfo getErrorForField(@NotNull String field) {
        for (ErrorInfo error : this.errors) {
            if (!field.equals(error.getField())) continue;
            return error;
        }
        return null;
    }

    @Nullable
    public ErrorInfo removeErrorForField(@NotNull String field, @Nullable String errorCode) {
        Iterator<ErrorInfo> it = this.errors.iterator();
        while (it.hasNext()) {
            ErrorInfo error = it.next();
            if (!field.equals(error.getField()) || errorCode != null && !errorCode.equals(error.getError())) continue;
            it.remove();
            return error;
        }
        return null;
    }

    @Nullable
    public ErrorInfo removeErrorForField(@NotNull String field) {
        return this.removeErrorForField(field, null);
    }

    @NotNull
    public Collection<ErrorInfo> removeErrorForFields(@NotNull Collection<String> fields, @Nullable String errorCode) {
        HashSet<ErrorInfo> removedErrors = new HashSet<ErrorInfo>();
        Iterator<ErrorInfo> it = this.errors.iterator();
        while (it.hasNext()) {
            ErrorInfo error = it.next();
            if (!fields.contains(error.getField()) || errorCode != null && !errorCode.equals(error.getError())) continue;
            it.remove();
            removedErrors.add(error);
        }
        return removedErrors;
    }

    @NotNull
    public Collection<ErrorInfo> removeErrorForFields(@NotNull Collection<String> fields) {
        return this.removeErrorForFields(fields, null);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ValidationResult: ");
        for (ErrorInfo key : this.errors) {
            result.append(key.getField()).append(" <== ").append(key.getError()).append(" [").append(key.getDescription()).append("];");
        }
        return result.toString();
    }

    public void updateFrom(ValidationResult result) {
        Collections.addAll(this.errors, result.getErrors());
        this.additionalInfo.putAll(result.getAdditionalInfo());
    }

    public static enum Error {
        INVALID_HUB_URL,
        INVALID_HUB_URL_HTTPS_REQUIRED,
        INVALID_HUB_URL_REDIRECT,
        UNTRUSTED_CERTIFICATE,
        CLIENT_CERTIFICATE_REQUIRED,
        HUB_SERVICE_HAS_NO_LICENSE,
        SERVICES_ARE_NOT_REGISTERERD;

    }
}

