/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.pem;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import jetbrains.jetpass.pem.KeyUtil$WhenMappings;
import jetbrains.jetpass.pem.KeyUtilKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/pem/KeyUtil;", "", "()V", "detectFormat", "Ljetbrains/jetpass/pem/KeyUtil$Format;", "data", "", "loadKeySpec", "Ljava/security/spec/KeySpec;", "keyText", "loadPrivateKey", "Ljava/security/PrivateKey;", "privateKeyPem", "loadPublicKey", "Ljava/security/PublicKey;", "publicKeySpec", "readPKCS1FormatKey", "keyData", "readPKCS8FormatKey", "readX509PublicKey", "publicKeyPem", "Format", "jetbrains.jetpass.saml"})
public final class KeyUtil {
    public static final KeyUtil INSTANCE;

    @NotNull
    public final PrivateKey loadPrivateKey(@NotNull String privateKeyPem) {
        Intrinsics.checkParameterIsNotNull((Object)privateKeyPem, (String)"privateKeyPem");
        KeySpec keySpec = this.loadKeySpec(privateKeyPem);
        PrivateKey privateKey = KeyUtilKt.access$getRSA_FACTORY$p().generatePrivate(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"RSA_FACTORY.generatePrivate(keySpec)");
        return privateKey;
    }

    @NotNull
    public final PublicKey loadPublicKey(@NotNull String publicKeySpec) {
        Intrinsics.checkParameterIsNotNull((Object)publicKeySpec, (String)"publicKeySpec");
        KeySpec keySpec = this.loadKeySpec(publicKeySpec);
        PublicKey publicKey = KeyUtilKt.access$getRSA_FACTORY$p().generatePublic(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"RSA_FACTORY.generatePublic(keySpec)");
        return publicKey;
    }

    @NotNull
    public final KeySpec loadKeySpec(@NotNull String keyText) {
        KeySpec keySpec;
        Intrinsics.checkParameterIsNotNull((Object)keyText, (String)"keyText");
        Format format = this.detectFormat(keyText);
        switch (KeyUtil$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                keySpec = this.readPKCS8FormatKey(format.unwrap(keyText));
                break;
            }
            case 2: {
                keySpec = this.readPKCS1FormatKey(format.unwrap(keyText));
                break;
            }
            case 3: {
                keySpec = this.readX509PublicKey(format.unwrap(keyText));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KeySpec keySpec2 = keySpec;
        return keySpec2;
    }

    private final Format detectFormat(String data) {
        GeneralSecurityException generalSecurityException;
        for (Format fmt : Format.values()) {
            if (!StringsKt.startsWith$default((String)data, (String)fmt.getBeginning(), (boolean)false, (int)2, null)) continue;
            return fmt;
        }
        String string = data;
        int n = 0;
        int n2 = Math.min(Format.PKCS_1_PRIVATE_KEY.getBeginning().length(), data.length());
        StringBuilder stringBuilder = new StringBuilder().append("Unknown format: ");
        GeneralSecurityException generalSecurityException2 = generalSecurityException;
        GeneralSecurityException generalSecurityException3 = generalSecurityException;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        generalSecurityException2(stringBuilder.append(string4).toString());
        throw (Throwable)generalSecurityException3;
    }

    private final KeySpec readPKCS1FormatKey(String keyData) {
        DerInputStream derReader = new DerInputStream(Base64.decodeBase64((String)keyData));
        DerValue[] seq = derReader.getSequence(0);
        if (seq.length < 9) {
            throw (Throwable)new GeneralSecurityException("Could not parse a PKCS1 private key.");
        }
        DerValue derValue = seq[1];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue, (String)"seq[1]");
        BigInteger modulus = derValue.getBigInteger();
        DerValue derValue2 = seq[2];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue2, (String)"seq[2]");
        BigInteger publicExp = derValue2.getBigInteger();
        DerValue derValue3 = seq[3];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue3, (String)"seq[3]");
        BigInteger privateExp = derValue3.getBigInteger();
        DerValue derValue4 = seq[4];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue4, (String)"seq[4]");
        BigInteger prime1 = derValue4.getBigInteger();
        DerValue derValue5 = seq[5];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue5, (String)"seq[5]");
        BigInteger prime2 = derValue5.getBigInteger();
        DerValue derValue6 = seq[6];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue6, (String)"seq[6]");
        BigInteger exp1 = derValue6.getBigInteger();
        DerValue derValue7 = seq[7];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue7, (String)"seq[7]");
        BigInteger exp2 = derValue7.getBigInteger();
        DerValue derValue8 = seq[8];
        Intrinsics.checkExpressionValueIsNotNull((Object)derValue8, (String)"seq[8]");
        BigInteger crtCoef = derValue8.getBigInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }

    private final KeySpec readPKCS8FormatKey(String privateKeyPem) {
        return new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyPem));
    }

    private final KeySpec readX509PublicKey(String publicKeyPem) {
        return new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyPem));
    }

    private KeyUtil() {
    }

    static {
        KeyUtil keyUtil;
        INSTANCE = keyUtil = new KeyUtil();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Ljetbrains/jetpass/pem/KeyUtil$Format;", "", "beginning", "", "ending", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getBeginning", "()Ljava/lang/String;", "getEnding", "unwrap", "keyData", "PKCS_8_PRIVATE_KEY", "PKCS_1_PRIVATE_KEY", "X509_PUBLIC_KEY", "jetbrains.jetpass.saml"})
    private static final class Format
    extends Enum<Format> {
        public static final /* enum */ Format PKCS_8_PRIVATE_KEY;
        public static final /* enum */ Format PKCS_1_PRIVATE_KEY;
        public static final /* enum */ Format X509_PUBLIC_KEY;
        private static final /* synthetic */ Format[] $VALUES;
        @NotNull
        private final String beginning;
        @NotNull
        private final String ending;

        static {
            Format[] formatArray = new Format[3];
            Format[] formatArray2 = formatArray;
            formatArray[0] = PKCS_8_PRIVATE_KEY = new Format("-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
            formatArray[1] = PKCS_1_PRIVATE_KEY = new Format("-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
            formatArray[2] = X509_PUBLIC_KEY = new Format("-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
            $VALUES = formatArray;
        }

        @NotNull
        public final String unwrap(@NotNull String keyData) {
            Intrinsics.checkParameterIsNotNull((Object)keyData, (String)"keyData");
            String privateKeyPem1 = StringsKt.replace$default((String)StringsKt.replace$default((String)keyData, (String)this.beginning, (String)"", (boolean)false, (int)4, null), (String)this.ending, (String)"", (boolean)false, (int)4, null);
            CharSequence charSequence = privateKeyPem1;
            String string = "\\s";
            string = new Regex(string);
            String string2 = "";
            return string.replace(charSequence, string2);
        }

        @NotNull
        public final String getBeginning() {
            return this.beginning;
        }

        @NotNull
        public final String getEnding() {
            return this.ending;
        }

        protected Format(String beginning, String ending) {
            Intrinsics.checkParameterIsNotNull((Object)beginning, (String)"beginning");
            Intrinsics.checkParameterIsNotNull((Object)ending, (String)"ending");
            this.beginning = beginning;
            this.ending = ending;
        }

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String string) {
            return Enum.valueOf(Format.class, string);
        }
    }
}

